package cn.com.duiba.cloud.jiuli.client.domian.result;

import cn.com.duiba.cloud.jiuli.client.domian.constants.HttpHeaders;
import com.google.common.collect.Maps;
import lombok.Data;
import org.apache.commons.lang3.StringUtils;

import java.io.InputStream;
import java.util.Map;

/**
 * @author liuyao
 */
@Data
public class GetFileResult {

    private InputStream fileContext;

    private Map<String,String> headers = Maps.newHashMap();

    public Long getContentLength(){
        String length = headers.get(HttpHeaders.CONTENT_LENGTH);
        if(StringUtils.isNotBlank(length)){
            return 0L;
        }
        return Long.parseLong(length);
    }

    public String getContentMd5(){
        return headers.get(HttpHeaders.CONTENT_MD5);
    }

    public String getContentType(){
        return headers.get(HttpHeaders.CONTENT_TYPE);
    }

    public void addHeader(String key,String value){
        headers.put(key,value);
    }

}
