package cn.com.duiba.cloud.jiuli.client.service;

import cn.com.duiba.boot.exception.BizException;
import cn.com.duiba.cloud.jiuli.client.JiuliFileClient;
import cn.com.duiba.cloud.jiuli.client.configuration.FileClientProperties;
import cn.com.duiba.cloud.jiuli.client.configuration.FileSpaceProperties;
import com.github.benmanes.caffeine.cache.CacheLoader;
import com.github.benmanes.caffeine.cache.Caffeine;
import com.github.benmanes.caffeine.cache.LoadingCache;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.springframework.context.ApplicationContext;

import javax.annotation.Resource;
import java.util.Objects;
import java.util.function.Function;

/**
 * @author wangxukai
 * @date ：Created in 2021/12/20
 */
public class JiuliFileClientManager {

    @Resource
    private FileClientProperties fileClientProperties;
    @Resource
    private ApplicationContext applicationContext;

    private final LoadingCache<String, JiuliFileClient> jiuliClientCache = Caffeine.newBuilder().build(new CacheLoader<String, JiuliFileClient>() {
        @Override
        public JiuliFileClient load(@NonNull String spaceKey) throws BizException {
            FileSpaceProperties properties = fileClientProperties.getSpaces().get(spaceKey);
            if(Objects.isNull(properties)){
                throw new BizException("没有文件空间的客户端配置");
            }
            JiuliFileClientImpl fileClient = applicationContext.getBean(JiuliFileClientImpl.class);
            fileClient.setSpaceKey(spaceKey);
            fileClient.setFileSpaceProperties(properties);
            fileClient.init();
            return fileClient;
        }
    });

    public JiuliFileClient getFileClient(String spaceKey){
        return jiuliClientCache.get(spaceKey);
    }

    /**
     * 自定义配置获取JiuliFileClient对象
     */
    public JiuliFileClient getFileClient(String spaceKey,Function<String,JiuliFileClient> clientCreator){
        return jiuliClientCache.get(spaceKey,clientCreator);
    }

}
