package cn.com.duiba.cloud.jiuli.client.service.auth;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import lombok.SneakyThrows;
import org.apache.commons.lang.StringUtils;

import java.nio.charset.StandardCharsets;
import java.security.MessageDigest;
import java.util.Base64;
import java.util.Collections;
import java.util.List;
import java.util.Map;

/**
 * @author liuyao
 */
public class SignatureUtils {

    /**
     * 签名3分钟之内有效
     */
    public static final Long TIME_OUT = 180000L;

    public static String sign(String spaceKey,String secret,String appId,Long timestamp) {
        Long now = System.currentTimeMillis();
        long def = now - timestamp;
        if(Math.abs(def)>TIME_OUT){
            throw new IllegalArgumentException("签名超时");
        }
        if(StringUtils.isBlank(secret)){
            throw new IllegalArgumentException("秘钥缺失");
        }
        Map<String,String> sourceMap = Maps.newHashMap();
        sourceMap.put("spaceKey", spaceKey);
        sourceMap.put("secret", secret);
        sourceMap.put("appId", appId);
        sourceMap.put("timestamp", timestamp.toString());

        List<String> keys = Lists.newArrayList(sourceMap.keySet());
        Collections.sort(keys);

        StringBuilder stringBuilder = new StringBuilder();
        for (String s : keys) {
            stringBuilder.append(sourceMap.get(s));
        }
        String src = stringBuilder.toString();
        return Base64.getEncoder().encodeToString(md5(src.getBytes(StandardCharsets.UTF_8)));
    }

    @SneakyThrows
    private static byte[] md5(byte[] data){
        MessageDigest md5 = MessageDigest.getInstance("MD5");
        md5.update(data);
        return md5.digest();
    }

}
