package cn.com.duiba.cloud.jiuli.client.service.event;

import cn.com.duiba.cloud.jiuli.client.domian.event.FileTaskEvent;
import org.apache.rocketmq.spring.annotation.RocketMQMessageListener;
import org.apache.rocketmq.spring.core.RocketMQListener;
import org.springframework.context.ApplicationContext;

import javax.annotation.Resource;

/**
 * 监听文件上传事件
 * @author liuyao
 */
@RocketMQMessageListener(
        topic = JiuliFileEventInfos.JIULI_FILE_EVENT_TOPIC,
        consumerGroup = "jiuli-listener-${spring.application.name}",
        selectorExpression= "${spring.application.name}"
)
public class JiuliFileEventMessageListener implements RocketMQListener<FileTaskEvent> {

    @Resource
    private ApplicationContext applicationContext;

    @Override
    public void onMessage(FileTaskEvent message) {
        applicationContext.publishEvent(message);
    }
}
