/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.cloud.jiuli.client.domian.request;

import cn.com.duiba.cloud.jiuli.client.utils.MultipartFileUtils;
import com.google.common.collect.Maps;
import java.io.File;
import java.io.InputStream;
import java.util.Map;
import java.util.Objects;
import org.springframework.web.multipart.MultipartFile;

public class PutFileRequest {
    private final MultipartFile file;
    private Map<String, String> metadata = Maps.newHashMap();

    public PutFileRequest(InputStream inputStream) {
        Objects.requireNonNull(inputStream);
        this.file = MultipartFileUtils.fileToMultipartFile(inputStream);
    }

    public PutFileRequest(File file) {
        Objects.requireNonNull(file);
        this.file = MultipartFileUtils.fileToMultipartFile(file);
    }

    public PutFileRequest(MultipartFile file) {
        Objects.requireNonNull(file);
        this.file = file;
    }

    public void addAllMetadata(Map<String, String> metadata) {
        this.metadata.putAll(metadata);
    }

    public void addMetadata(String key, String value) {
        this.metadata.put(key, value);
    }

    public void setContentType(String contentType) {
        this.metadata.put("Content-Type", contentType);
    }

    public MultipartFile getFile() {
        return this.file;
    }

    public Map<String, String> getMetadata() {
        return this.metadata;
    }

    public void setMetadata(Map<String, String> metadata) {
        this.metadata = metadata;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof PutFileRequest)) {
            return false;
        }
        PutFileRequest other = (PutFileRequest)o;
        if (!other.canEqual(this)) {
            return false;
        }
        MultipartFile this$file = this.getFile();
        MultipartFile other$file = other.getFile();
        if (this$file == null ? other$file != null : !this$file.equals(other$file)) {
            return false;
        }
        Map<String, String> this$metadata = this.getMetadata();
        Map<String, String> other$metadata = other.getMetadata();
        return !(this$metadata == null ? other$metadata != null : !((Object)this$metadata).equals(other$metadata));
    }

    protected boolean canEqual(Object other) {
        return other instanceof PutFileRequest;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        MultipartFile $file = this.getFile();
        result = result * 59 + ($file == null ? 43 : $file.hashCode());
        Map<String, String> $metadata = this.getMetadata();
        result = result * 59 + ($metadata == null ? 43 : ((Object)$metadata).hashCode());
        return result;
    }

    public String toString() {
        return "PutFileRequest(file=" + this.getFile() + ", metadata=" + this.getMetadata() + ")";
    }
}

