/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.cloud.jiuli.client.service;

import cn.com.duiba.boot.exception.BizException;
import cn.com.duiba.cloud.jiuli.client.JiuliFileClient;
import cn.com.duiba.cloud.jiuli.client.configuration.FileSpaceProperties;
import cn.com.duiba.cloud.jiuli.client.domian.dto.FileDto;
import cn.com.duiba.cloud.jiuli.client.domian.params.AppendFileParams;
import cn.com.duiba.cloud.jiuli.client.domian.params.CreateDirParams;
import cn.com.duiba.cloud.jiuli.client.domian.params.ImageChangeParams;
import cn.com.duiba.cloud.jiuli.client.domian.params.ListFileParams;
import cn.com.duiba.cloud.jiuli.client.domian.params.PutFileParams;
import cn.com.duiba.cloud.jiuli.client.domian.params.RefreshCdnParams;
import cn.com.duiba.cloud.jiuli.client.domian.request.PutFileRequest;
import cn.com.duiba.cloud.jiuli.client.domian.result.CdnFlushResult;
import cn.com.duiba.cloud.jiuli.client.domian.result.GetFileResult;
import cn.com.duiba.cloud.jiuli.client.domian.result.PutFileResult;
import cn.com.duiba.cloud.jiuli.client.remote.RemoteJiuliCdnApi;
import cn.com.duiba.cloud.jiuli.client.remote.RemoteJiuliFileApi;
import cn.com.duiba.cloud.jiuli.client.remote.RemoteJiuliImageApi;
import cn.com.duiba.cloud.jiuli.client.service.auth.JiuliClientAuthRequestInterceptor;
import cn.com.duiba.cloud.jiuli.client.utils.MultipartFileUtils;
import com.google.common.base.Joiner;
import feign.Response;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.web.multipart.MultipartFile;

public class JiuliFileClientImpl
implements JiuliFileClient {
    private static final Logger log = LoggerFactory.getLogger(JiuliFileClientImpl.class);
    private String spaceKey;
    private FileSpaceProperties fileSpaceProperties;
    @Resource
    private RemoteJiuliFileApi remoteJiuliFileClient;
    @Resource
    private RemoteJiuliImageApi remoteJiuliImageApi;
    @Resource
    private RemoteJiuliCdnApi remoteJiuliCdnApi;
    @Resource
    private JiuliClientAuthRequestInterceptor jiuliClientAuthRequestInterceptor;

    public void init() {
        Objects.requireNonNull(this.spaceKey);
        Objects.requireNonNull(this.fileSpaceProperties);
        this.jiuliClientAuthRequestInterceptor.registerSecret(this.spaceKey, this.fileSpaceProperties.getSecret());
    }

    @Override
    public String getSpaceKey() {
        return this.spaceKey;
    }

    @Override
    public List<FileDto> listFile(ListFileParams params) throws BizException {
        return this.remoteJiuliFileClient.listFile(this.spaceKey, params);
    }

    @Override
    public void createFolder(String filePath) throws BizException {
        CreateDirParams param = new CreateDirParams(filePath);
        this.remoteJiuliFileClient.createFolder(this.spaceKey, param);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public PutFileResult putFile(String fileId, PutFileRequest request) throws BizException {
        Objects.requireNonNull(fileId, "fileId \u4e0d\u80fd\u4e3a\u7a7a");
        PutFileParams param = new PutFileParams();
        param.setFileId(fileId);
        param.setMetadata(request.getMetadata());
        if (Objects.isNull(request.getFile())) {
            throw new IllegalArgumentException("\u7f3a\u5c11\u4e0a\u4f20\u5185\u5bb9");
        }
        try {
            PutFileResult putFileResult = this.remoteJiuliFileClient.putFile(this.spaceKey, param, request.getFile());
            return putFileResult;
        }
        finally {
            MultipartFileUtils.cleanLocalFile(request.getFile());
        }
    }

    @Override
    public GetFileResult getFile(String filePath) throws BizException {
        try {
            Joiner joiner = Joiner.on((String)",").skipNulls();
            Response response = this.remoteJiuliFileClient.fetchFile(this.spaceKey, filePath);
            Map headers = response.headers();
            GetFileResult result = new GetFileResult();
            result.setFileContext(response.body().asInputStream());
            for (String key : headers.keySet()) {
                result.addHeader(key, joiner.join((Iterable)headers.get(key)));
            }
            return result;
        }
        catch (IOException e) {
            log.error("\u83b7\u53d6\u6587\u4ef6\u6d41\u5931\u8d25", (Throwable)e);
            throw new BizException("\u83b7\u53d6\u6587\u4ef6\u6d41\u5931\u8d25");
        }
    }

    @Override
    public void getFile(String filePath, File file) throws BizException, IOException {
        try (InputStream inputStream = this.getFile(filePath).getFileContext();
             FileOutputStream outputStream = new FileOutputStream(file);){
            int read;
            byte[] bytes = new byte[1024];
            while ((read = inputStream.read(bytes)) != -1) {
                outputStream.write(bytes, 0, read);
            }
        }
    }

    @Override
    public Boolean fileExist(String fileId) throws BizException {
        return this.remoteJiuliFileClient.fileExist(this.spaceKey, fileId).getExist();
    }

    @Override
    public void deleteFile(String fileId) throws BizException {
        this.remoteJiuliFileClient.deleteFile(this.spaceKey, fileId);
    }

    @Override
    public void appendToFile(String fileId, Long position, InputStream inputStream) throws BizException {
        AppendFileParams params = new AppendFileParams();
        params.setFileId(fileId);
        params.setPosition(position);
        MultipartFile multipartFile = MultipartFileUtils.fileToMultipartFile(inputStream);
        this.remoteJiuliFileClient.appendFile(this.spaceKey, params, multipartFile);
    }

    @Override
    public String imageChange(ImageChangeParams params) throws BizException {
        return this.remoteJiuliImageApi.imageChange(this.spaceKey, params);
    }

    @Override
    public List<CdnFlushResult> refreshCdn(RefreshCdnParams params) throws BizException {
        return this.remoteJiuliCdnApi.refreshCdn(this.spaceKey, params);
    }

    public void setSpaceKey(String spaceKey) {
        this.spaceKey = spaceKey;
    }

    public void setFileSpaceProperties(FileSpaceProperties fileSpaceProperties) {
        this.fileSpaceProperties = fileSpaceProperties;
    }
}

