/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.cloud.jiuli.client.service;

import cn.com.duiba.boot.exception.BizException;
import cn.com.duiba.cloud.jiuli.client.JiuliFileClient;
import cn.com.duiba.cloud.jiuli.client.configuration.FileClientProperties;
import cn.com.duiba.cloud.jiuli.client.configuration.FileSpaceProperties;
import cn.com.duiba.cloud.jiuli.client.service.JiuliFileClientImpl;
import com.github.benmanes.caffeine.cache.CacheLoader;
import com.github.benmanes.caffeine.cache.Caffeine;
import com.github.benmanes.caffeine.cache.LoadingCache;
import java.util.Objects;
import java.util.function.Function;
import javax.annotation.Resource;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.springframework.context.ApplicationContext;

public class JiuliFileClientManager {
    @Resource
    private FileClientProperties fileClientProperties;
    @Resource
    private ApplicationContext applicationContext;
    private final LoadingCache<String, JiuliFileClient> jiuliClientCache = Caffeine.newBuilder().build((CacheLoader)new CacheLoader<String, JiuliFileClient>(){

        public JiuliFileClient load(@NonNull String spaceKey) throws BizException {
            FileSpaceProperties properties = JiuliFileClientManager.this.fileClientProperties.getSpaces().get(spaceKey);
            if (Objects.isNull(properties)) {
                throw new BizException("\u6ca1\u6709\u6587\u4ef6\u7a7a\u95f4\u7684\u5ba2\u6237\u7aef\u914d\u7f6e");
            }
            JiuliFileClientImpl fileClient = (JiuliFileClientImpl)JiuliFileClientManager.this.applicationContext.getBean(JiuliFileClientImpl.class);
            fileClient.setSpaceKey(spaceKey);
            fileClient.setFileSpaceProperties(properties);
            fileClient.init();
            return fileClient;
        }
    });

    public JiuliFileClient getFileClient(String spaceKey) {
        return (JiuliFileClient)this.jiuliClientCache.get((Object)spaceKey);
    }

    public JiuliFileClient getFileClient(String spaceKey, Function<String, JiuliFileClient> clientCreator) {
        return (JiuliFileClient)this.jiuliClientCache.get((Object)spaceKey, clientCreator);
    }
}

