/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.cloud.jiuli.client.utils;

import cn.com.duiba.wolf.utils.UUIDUtils;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.apache.commons.fileupload.FileItem;
import org.apache.commons.fileupload.FileItemFactory;
import org.apache.commons.fileupload.disk.DiskFileItemFactory;
import org.apache.http.entity.ContentType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.web.multipart.MultipartFile;
import org.springframework.web.multipart.commons.CommonsMultipartFile;

public class MultipartFileUtils {
    private static final Logger log = LoggerFactory.getLogger(MultipartFileUtils.class);
    private static final String FILE_PATH = ".jiuli/client-temp-files/";
    private static final FileItemFactory FILE_ITEM_FACTORY;
    private static final int UPLOAD_BUFF_SIZE = 8192;

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static MultipartFile fileToMultipartFile(File file) {
        try (FileInputStream fileInputStream = new FileInputStream(file);){
            FileItem fileItem = MultipartFileUtils.createFileItem(fileInputStream);
            CommonsMultipartFile commonsMultipartFile = new CommonsMultipartFile(fileItem);
            return commonsMultipartFile;
        }
        catch (IOException e) {
            throw new IllegalArgumentException("\u83b7\u53d6\u6587\u4ef6\u5185\u5bb9\u5931\u8d25", e);
        }
    }

    public static MultipartFile fileToMultipartFile(InputStream inputStream) {
        FileItem fileItem = MultipartFileUtils.createFileItem(inputStream);
        return new CommonsMultipartFile(fileItem);
    }

    public static void cleanLocalFile(MultipartFile file) {
        if (file instanceof CommonsMultipartFile) {
            CommonsMultipartFile commonsMultipartFile = (CommonsMultipartFile)file;
            FileItem fileItem = commonsMultipartFile.getFileItem();
            fileItem.delete();
        }
    }

    private static FileItem createFileItem(InputStream inputStream) {
        FileItem item = FILE_ITEM_FACTORY.createItem("file", ContentType.APPLICATION_OCTET_STREAM.toString(), true, UUIDUtils.createUUID() + ".dat");
        byte[] buffer = new byte[8192];
        try (OutputStream os = item.getOutputStream();){
            int bytesRead;
            while ((bytesRead = inputStream.read(buffer, 0, 8192)) != -1) {
                os.write(buffer, 0, bytesRead);
            }
        }
        catch (IOException e) {
            log.error("\u6587\u4ef6\u6d41\u8f6c\u5316\u5931\u8d25", (Throwable)e);
        }
        return item;
    }

    static {
        String webRootDir = System.getProperty("user.home");
        File userDir = new File(webRootDir, FILE_PATH);
        if (!userDir.exists() && userDir.mkdirs()) {
            log.debug("\u4e34\u65f6\u6587\u4ef6\u5939\u521b\u5efa\u6210\u529f");
        }
        FILE_ITEM_FACTORY = new DiskFileItemFactory(10240, userDir);
    }
}

