## 九黎对象存储客户端文档

## 1.概念解释
文件空间：文件空间是九黎对文件进行管理的基本单位，在使用客户端的时候，也是以文件空间作为对象来进行对接的。
每个文件空间有一个全局唯一的标识（key），对接时，这个标识是个重要的参数，用于告诉客户端操作的是哪一个文件空间。

fileId：是文件空间中某一个文件的唯一标识，如：aaa/bbb/test.txt
一方面在调用api时，作为单个文件唯一的key,另一方面，也标示了文件相对与空间根目录的相对路径

## 2.对接
九黎客户端基于 spring-boot-starter 风格打造，只需要引入jar,即可使用

compile "cn.com.duiba.jiu-li:jiuli-client:1.0.6"

## 3.配置
项目在使用九黎客户端对接一个文件空间的时，需要得到空间的授权，授权后就能产生一个秘钥。

授权过程：

1. 在九黎的空间列表页找到空间的负责，如果自己是负责人，直接进入到空间详情   
2. 在空间详情的右上角点开 设置下拉菜单，授权应用
3. 检索需要对接的应用，添加即完成对应用的授权，点击钉钉查看就可以获取到该应用对接该空间的秘钥了

获取到秘钥后，在系统的apollo配置添加配置，配置格式为
```
duiba.cloud.jiuli.spaces.[空间标识].secret=[秘钥]
```
空间标识：是对接该空间的唯一标识符，在空间列表页可以获取到
秘钥：则为授权过程获取到的秘钥，在添加配置时，安全起见，**给配置加密**

只有配置了该空间的秘钥，在调api阶段才能对该空间进行各种操作

## 4.对接过程

九黎客户端的功能分为三个部分

1. 通过客户端进行文件操作

JiuliFileClient 是原型的，每配置一个空间的秘钥，都对应一个客户端实例

JiuliFileClientManager 是客户端的管理器，通过传入空间标识获取该空间的客户端

其他具体的文件操作可以查看 JiuliFileClient 接口的注释，都有详细的说明

```
@RestController
@RequestMapping("/jiuli/test")
public class TestController {

    @Resource
    private JiuliFileClientManager jiuliFileClientManager;

    @CsrfOff
    @GetMapping("/test")
    public String test() {
        JiuliFileClient client = jiuliFileClientManager.getFileClient("空间标识");

        try(ByteArrayInputStream inputStream = new ByteArrayInputStream("测试文本\n".getBytes(StandardCharsets.UTF_8));) {

            //获取文件
            FetchResult fetchResult = client.fetchFile("test.txt");
            //文件源信息
            MetadataInfo metadataInfo = fetchResult.getMetadataInfo();
            //普通上传,
            PutFileParams putFileParams = new PutFileParams();
            putFileParams.setFileId("test-put.txt");
            PutFileResult putFileResult = client.putFile(putFileParams,inputStream);


            //追加上传，注：putFile 上传的文件不能进行追加追加上传
            AppendParams params = new AppendParams();
            //从元数据中能够获取到当前文件的长度
            params.setPosition(metadataInfo.getContentLength());
            params.setFileId("test.txt");
            AppendResult result = client.appendToFile(params, inputStream);
            //下一次追加可以直接用 NextPosition ，而不用再从元数据中获取
            System.out.println("新长度:"+result.getNextPosition());
        } catch (Exception e) {
            e.printStackTrace();
        }
        return "ok";
    }

}
```

2. 通过api接口进行一些附加的操作
```
RemoteJiuliImageApi.imageChange  可对图片类型的文件进行，尺寸调整和品质压缩处理

RemoteJiuliCdnApi.refreshCdn  可以对特定的目录或者文件进行CDN的刷新处理
```

3. 事件
九黎的 putFile 和 imageChange 等一些操作是非常耗时的，九黎在内部做了异步处理，在调用该方法后能得到一个requestId。
如果开启了事件模块，就能通过spring原生的方式监听到对应文件的处理完成事件
```
   @EventListener(FileTaskEvent.class)
   public void eventListener(FileTaskEvent event){
         //do something
   }
```
FileTaskEvent 也有 requestId 字段，用于和之前的操作进行匹配

事件模块开启方式
1. 引入rocketmq，如果引了最新版本的 duiba-boot-ext的 rocketmq模块，会自动依赖该rocketmq官方依赖
```
compile 'org.apache.rocketmq:rocketmq-spring-boot-starter:2.2.1'
```
2. 在apollo关联公共Namespace (rocketmq-boot-starter),完成对 rocketmq 的配置







