package cn.com.duiba.cloud.jiuli.client;

import cn.com.duiba.boot.exception.BizException;
import cn.com.duiba.cloud.jiuli.client.domian.dto.FileDto;
import cn.com.duiba.cloud.jiuli.client.domian.params.AppendParams;
import cn.com.duiba.cloud.jiuli.client.domian.params.ListFileParams;
import cn.com.duiba.cloud.jiuli.client.domian.params.PutFileParams;
import cn.com.duiba.cloud.jiuli.client.domian.result.AppendResult;
import cn.com.duiba.cloud.jiuli.client.domian.result.DeleteResult;
import cn.com.duiba.cloud.jiuli.client.domian.result.FetchResult;
import cn.com.duiba.cloud.jiuli.client.domian.result.PutFileResult;
import org.springframework.web.multipart.MultipartFile;

import java.io.File;
import java.io.InputStream;
import java.util.List;

/**
 * 九黎文件操作客户端
 * @author liuyao
 */
public interface JiuliFileClient {

    /**
     * 空间标识
     * @return 空间标识
     */
    String getSpaceKey();

    /**
     * 列举子级文件
     * @param params 请求参数
     * @return 子级文件项
     * @throws BizException 查询失败
     */
    List<FileDto> findChildFiles(ListFileParams params) throws BizException;

    /**
     * * 获取文件流
     * @param fileId 文件路径
     * @return 文件对象
     * @throws BizException 拉取失败
     */
    FetchResult fetchFile(String fileId) throws BizException;

    /**
     * 创建文件夹
     * @param folderPath 文件夹路径，以 / 结尾
     * @throws BizException 创建失败
     */
    void createFolder(String folderPath) throws BizException;

    /**
     * 上传文件
     * @param params 上传参数
     * @param file 将要上传的文件
     * @return 上传结果
     * @throws BizException 上传失败
     */
    PutFileResult putFile(PutFileParams params,File file) throws BizException;

    /**
     * 流式上传
     * @param params 上传参数
     * @param inputStream 数据流
     * @return 上传结果
     * @throws BizException 上传失败
     */
    PutFileResult putFile(PutFileParams params,InputStream inputStream) throws BizException;
    /**
     * Web 上传
     * @param params 上传参数
     * @param multipartFile 数据流
     * @return 上传结果
     * @throws BizException 上传失败
     */
    PutFileResult putFile(PutFileParams params, MultipartFile multipartFile) throws BizException;

    /**
     * 追加上传
     * 文件类型为追加类型，不同于 putFile ，追加上传创建的文件可以进行下一次的追加
     * @param params 上传参数
     * @param inputStream 追加内容
     * @return 追加结果
     * @throws BizException 异常
     */
    AppendResult appendToFile(AppendParams params, InputStream inputStream) throws BizException;

    /**
     * 文件是否存在
     *
     * @param filePath 文件路径
     * @return 是否存在
     * @throws BizException 请求失败
     */
    Boolean fileExist(String filePath) throws BizException;

    /**
     * 删除文件或目录
     * 如果删除目录，则会同时删除子级所有目录和文件
     * @param filePath 文件路径
     * @throws BizException 请求失败
     * @return 删除结果
     */
    DeleteResult deleteFile(String filePath) throws BizException;

}
