package cn.com.duiba.cloud.jiuli.client.domian.constants;

import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import org.apache.commons.lang3.StringUtils;

import java.util.Locale;
import java.util.Map;
import java.util.Set;

/**
 * @author liuyao
 */
public class HttpHeaders {

    private static final Map<String,String> LOWERCASE_HEADERS = Maps.newHashMap();

    public static final String AUTHORIZATION = "Authorization";
    public static final String CACHE_CONTROL = "Cache-Control";
    public static final String CONTENT_DISPOSITION = "Content-Disposition";
    public static final String CONTENT_ENCODING = "Content-Encoding";
    public static final String CONTENT_LENGTH = "Content-Length";
    public static final String CONTENT_MD5 = "Content-MD5";
    public static final String CONTENT_TYPE = "Content-Type";

    public static final String LAST_MODIFIED = "Last-Modified";
    public static final String EXPIRES = "Expires";

    static {
        appendHeader(AUTHORIZATION);
        appendHeader(CACHE_CONTROL);
        appendHeader(CONTENT_DISPOSITION);
        appendHeader(CONTENT_ENCODING);
        appendHeader(CONTENT_LENGTH);
        appendHeader(CONTENT_MD5);
        appendHeader(CONTENT_TYPE);
        appendHeader(LAST_MODIFIED);
        appendHeader(EXPIRES);
    }

    private static void appendHeader(String header){
        LOWERCASE_HEADERS.put(header.toLowerCase(),header);
    }

    public static String formatHeader(String header){
        String lowercase = header.toLowerCase();
        return LOWERCASE_HEADERS.getOrDefault(lowercase,header);
    }

}
