package cn.com.duiba.cloud.jiuli.client.exception;

/**
 * @author wangxukai
 * @date ：Created in 2021/11/18
 */
public enum JiuliErrorCode {

    ERROR("999999", "未知异常"),
    NOT_NULL("999100","参数异常"),
    /*------------------ fileClient统一异常 ----------------------*/
    NO_CLIENT("001001", "无对应文件服务系统"),
    NO_SECRET("001002","无访问密钥"),
    /*---------------oss操作异常------------------*/
    UPLOAD_ERROR("002001", "上传异常"),
    APPEND_UPLOAD_ERROR("002002", "追加上传异常"),
    DOWNLOAD_LOCAL_ERROR("002003", "下载到本地文件异常"),
    DOWNLOAD_STREAM_ERROR("002004", "流式下载异常"),
    QUERY_EXIST_ERROR("002005", "查询文件是否存在异常"),
    LIST_FILE_ERROR("002006", "查询文件列表异常"),
    DEL_FILE_ERROR("002007", "删除文件异常"),
    TEST_OSS("002008", "联通oss异常"),
    CREATE_DIR_ERROR("002009", "创建文件夹异常"),
    CREATE_LINK_ERROR("002010","创建链接异常"),
    /*----------------权限操作----------------------*/
    NOT_OWNER("003001","无权限操作"),
    CANNOT_DEL_CREATOR("003002","无法删除创建者"),
    CREATE_OWNER_ERROR("003003","创建权限者异常"),
    /*----------------文件空间操作----------------------*/
    CREATE_SPACE_ERROR("004001","创建文件空间异常"),
    FIND_SPACE_ERROR("004002","查询文件空间异常"),
    UPDATE_SPACE_CONFIG_ERROR("004003","更新空间配置异常"),
    /*------------------授权应用操作-----------------------*/
    FIND_APP_ERROR("005001","获取授权应用异常"),
    ;
    private String code;

    private String msg;

    JiuliErrorCode(String code, String msg) {
        this.code = code;
        this.msg = msg;
    }

    public String getCode() {
        return code;
    }

    public String getMsg() {
        return msg;
    }
}
