package cn.com.duiba.cloud.jiuli.client.remote;

import cn.com.duiba.boot.exception.BizException;
import cn.com.duiba.cloud.jiuli.client.domian.constants.RequestParamConstants;
import cn.com.duiba.cloud.jiuli.client.domian.params.RefreshCdnParams;
import cn.com.duiba.cloud.jiuli.client.domian.result.CdnFlushResult;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;

import java.util.List;

/**
 * @author liuyao
 */
@FeignClient(name="jiuli-file-center")
@RequestMapping("/api/cdn")
public interface RemoteJiuliCdnApi {

    /**
     * 刷新 CDN
     * @throws BizException 未开启公网访问
     */
    @PostMapping("/refreshCdn")
    List<CdnFlushResult> refreshCdn(@RequestParam(RequestParamConstants.SPACE_KEY) String spaceKey, @RequestBody RefreshCdnParams params) throws BizException;

}
