package cn.com.duiba.cloud.jiuli.client.remote;

import cn.com.duiba.boot.exception.BizException;
import cn.com.duiba.cloud.jiuli.client.domian.constants.RequestParamConstants;
import cn.com.duiba.cloud.jiuli.client.domian.dto.FileDto;
import cn.com.duiba.cloud.jiuli.client.domian.params.AppendParams;
import cn.com.duiba.cloud.jiuli.client.domian.params.CreateDirParams;
import cn.com.duiba.cloud.jiuli.client.domian.params.ListFileParams;
import cn.com.duiba.cloud.jiuli.client.domian.params.PutFileParams;
import cn.com.duiba.cloud.jiuli.client.domian.result.AppendResult;
import cn.com.duiba.cloud.jiuli.client.domian.result.DeleteResult;
import cn.com.duiba.cloud.jiuli.client.domian.result.FileExistResult;
import cn.com.duiba.cloud.jiuli.client.domian.result.PutFileResult;
import feign.Response;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.http.MediaType;
import org.springframework.web.bind.annotation.*;
import org.springframework.web.multipart.MultipartFile;

import java.util.List;

/**
 * @author liuyao
 */
@FeignClient(name="jiuli-file-center")
@RequestMapping("/api/file")
public interface RemoteJiuliFileApi {

    /**
     * 上传文件
     * @return 文件链接
     */
    @PostMapping(value = "/putFile", consumes = MediaType.MULTIPART_FORM_DATA_VALUE)
    PutFileResult putFile(@RequestParam(RequestParamConstants.SPACE_KEY) String spaceKey,@RequestPart("params") PutFileParams params,
                             @RequestPart(value = "file") MultipartFile file) throws BizException;

    /**
     * 追加文件内容,暂时只提供末尾追加
     * @param params 追加参数
     * @throws BizException 不存在，不是文件
     */
    @PostMapping(value = "/appendFile", consumes = MediaType.MULTIPART_FORM_DATA_VALUE)
    AppendResult appendFile(@RequestParam(RequestParamConstants.SPACE_KEY) String spaceKey, @RequestPart("params") AppendParams params,
                            @RequestPart(value = "file") MultipartFile file) throws BizException;

    /**
     * 下载文件
     * @return 文件数据
     */
    @GetMapping(value = "/fetchFile")
    Response fetchFile(@RequestParam(RequestParamConstants.SPACE_KEY) String spaceKey,@RequestParam("filePath") String filePath) throws BizException;


    /**
     * 判断文件是否存在
     * @return true:存在
     */
    @GetMapping(value = "/fileExist")
    FileExistResult fileExist(@RequestParam(RequestParamConstants.SPACE_KEY) String spaceKey,@RequestParam("filePath") String filePath) throws BizException;

    /**
     * 删除
     * 如果路径是文件夹，则删除文件夹下所有文件
     * 如果路径是文件，则删除单个文件
     */
    @DeleteMapping(value = "/deleteFile")
    DeleteResult deleteFile(@RequestParam(RequestParamConstants.SPACE_KEY) String spaceKey, @RequestParam("filePath") String filePath) throws BizException;
    /**
     * 列举文件信息
     * @param params 请求参数
     * @return 文件和文件夹列表
     */
    @PostMapping("/listFile")
    List<FileDto> listFile(@RequestParam(RequestParamConstants.SPACE_KEY) String spaceKey, @RequestBody ListFileParams params) throws BizException;


    /**
     * 创建文件夹
     *
     * @param params 请求参数
     */
    @PostMapping("/createFolder")
    void createFolder(@RequestParam(RequestParamConstants.SPACE_KEY) String spaceKey, @RequestBody CreateDirParams params) throws BizException;

}
