package cn.com.duiba.cloud.jiuli.client.remote;

import cn.com.duiba.boot.exception.BizException;
import cn.com.duiba.cloud.jiuli.client.domian.constants.RequestParamConstants;
import cn.com.duiba.cloud.jiuli.client.domian.params.ImageChangeParams;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.*;

import java.util.Set;

/**
 * @author liuyao
 */
@FeignClient(name="jiuli-file-center")
@RequestMapping("/api/image")
public interface RemoteJiuliImageApi {

    @GetMapping("/isImageType")
    Boolean isImageType(@RequestParam("fileType") String fileType);

    @GetMapping("/imageTypes")
    Set<String> imageTypes();
    /**
     * 图片处理
     * @param spaceKey 空间
     * @param params 参数
     * @return 处理任务号
     */
    @PostMapping("/imageChange")
    String imageChange(@RequestParam(RequestParamConstants.SPACE_KEY) String spaceKey, @RequestBody ImageChangeParams params) throws BizException;

}
