package cn.com.duiba.cloud.jiuli.client.service;

import cn.com.duiba.cloud.jiuli.client.JiuliFileClient;
import cn.com.duiba.cloud.jiuli.client.configuration.FileClientProperties;
import cn.com.duiba.cloud.jiuli.client.configuration.FileSpaceProperties;
import com.github.benmanes.caffeine.cache.CacheLoader;
import com.github.benmanes.caffeine.cache.Caffeine;
import com.github.benmanes.caffeine.cache.LoadingCache;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.springframework.context.ApplicationContext;

import javax.annotation.Resource;
import java.util.Objects;

/**
 * 默认客户端工厂
 * @author liuyao
 */
public class DefaultJiuliFileClientFactory implements JiuliFileClientFactory {

    @Resource
    private FileClientProperties fileClientProperties;
    @Resource
    private ApplicationContext applicationContext;

    private final LoadingCache<String,String> secretSource = Caffeine.newBuilder().build(new CacheLoader<String, String>() {
        @Override
        public @Nullable String load(@NonNull String spaceKey) {
            FileSpaceProperties properties = fileClientProperties.getSpaces().get(spaceKey);
            if(Objects.isNull(properties)){
                throw new RuntimeException("没有文件空间["+spaceKey+"]配置");
            }
            return properties.getSecret();
        }
    });

    @Override
    public JiuliFileClient build(String spaceKey) {
        FileSpaceProperties properties = fileClientProperties.getSpaces().get(spaceKey);
        if(Objects.isNull(properties)){
            throw new RuntimeException("没有文件空间的客户端配置");
        }
        JiuliFileClientImpl fileClient = applicationContext.getBean(JiuliFileClientImpl.class);
        fileClient.setSpaceKey(spaceKey);
        return fileClient;
    }

    @Override
    public LoadingCache<String, String> secretSource() {
        return secretSource;
    }

}