package cn.com.duiba.cloud.jiuli.client.service;

import cn.com.duiba.cloud.jiuli.client.JiuliFileClient;
import com.github.benmanes.caffeine.cache.CacheLoader;
import com.github.benmanes.caffeine.cache.Caffeine;
import com.github.benmanes.caffeine.cache.LoadingCache;
import org.checkerframework.checker.nullness.qual.NonNull;

import javax.annotation.Resource;

/**
 * 九黎客户端管理器
 * @author liuyao
 * @date ：Created in 2021/12/20
 */
public class JiuliFileClientManager {

    @Resource
    private JiuliFileClientFactory jiuliFileClientFactory;

    private final LoadingCache<String, JiuliFileClient> jiuliClientCache = Caffeine.newBuilder().build(new CacheLoader<String, JiuliFileClient>() {
        @Override
        public JiuliFileClient load(@NonNull String spaceKey) {
            return jiuliFileClientFactory.build(spaceKey);
        }
    });

    public JiuliFileClient getFileClient(String spaceKey){
        return jiuliClientCache.get(spaceKey);
    }

}
