package cn.com.duiba.cloud.jiuli.client.utils;

import cn.com.duiba.wolf.utils.UUIDUtils;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.fileupload.FileItem;
import org.apache.commons.fileupload.FileItemFactory;
import org.apache.commons.fileupload.disk.DiskFileItemFactory;
import org.apache.http.entity.ContentType;
import org.springframework.web.multipart.MultipartFile;
import org.springframework.web.multipart.commons.CommonsMultipartFile;

import java.io.*;

/**
 * @author liuyao
 */
@Slf4j
public class MultipartFileUtils {

    private static final String FILE_PATH = ".jiuli/client-temp-files/";
    private static final FileItemFactory FILE_ITEM_FACTORY;
    private static final int UPLOAD_BUFF_SIZE = 8192;

    static {
        String webRootDir = System.getProperty("user.home");
        File userDir = new File(webRootDir,FILE_PATH);
        if (!userDir.exists() && userDir.mkdirs()) {
            log.debug("临时文件夹创建成功");
        }
        //超过10K的上传量，将会写入文件再上传
        FILE_ITEM_FACTORY = new DiskFileItemFactory(DiskFileItemFactory.DEFAULT_SIZE_THRESHOLD, userDir);
    }

    public static MultipartFile fileToMultipartFile(File file){
        try(FileInputStream fileInputStream = new FileInputStream(file)){
            FileItem fileItem = createFileItem(fileInputStream);
            return new CommonsMultipartFile(fileItem);
        }catch (IOException e) {
            throw new IllegalArgumentException("获取文件内容失败",e);
        }
    }

    public static MultipartFile fileToMultipartFile(InputStream inputStream){
        FileItem fileItem = createFileItem(inputStream);
        return new CommonsMultipartFile(fileItem);
    }

    /**
     * 清理上传缓存文件
     */
    public static void cleanLocalFile(MultipartFile file){
        if(file instanceof CommonsMultipartFile){
            CommonsMultipartFile commonsMultipartFile = (CommonsMultipartFile) file;
            FileItem fileItem = commonsMultipartFile.getFileItem();
            fileItem.delete();
        }
    }

    private static FileItem createFileItem(InputStream inputStream) {
        FileItem item = FILE_ITEM_FACTORY.createItem("file", ContentType.APPLICATION_OCTET_STREAM.toString(), true, UUIDUtils.createUUID()+".dat");
        int bytesRead;
        byte[] buffer = new byte[UPLOAD_BUFF_SIZE];
        try (OutputStream os = item.getOutputStream()){
            while ((bytesRead = inputStream.read(buffer, 0, UPLOAD_BUFF_SIZE)) != -1) {
                os.write(buffer, 0, bytesRead);
            }
        } catch (IOException e) {
            log.error("文件流转化失败",e);
        }
        return item;
    }


}
