/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.cloud.jiuli.client.domian.constants;

import com.google.common.collect.Maps;
import java.util.Map;

public class HttpHeaders {
    private static final Map<String, String> LOWERCASE_HEADERS = Maps.newHashMap();
    public static final String AUTHORIZATION = "Authorization";
    public static final String CACHE_CONTROL = "Cache-Control";
    public static final String CONTENT_DISPOSITION = "Content-Disposition";
    public static final String CONTENT_ENCODING = "Content-Encoding";
    public static final String CONTENT_LENGTH = "Content-Length";
    public static final String CONTENT_MD5 = "Content-MD5";
    public static final String CONTENT_TYPE = "Content-Type";
    public static final String LAST_MODIFIED = "Last-Modified";
    public static final String EXPIRES = "Expires";

    private static void appendHeader(String header) {
        LOWERCASE_HEADERS.put(header.toLowerCase(), header);
    }

    public static String formatHeader(String header) {
        String lowercase = header.toLowerCase();
        return LOWERCASE_HEADERS.getOrDefault(lowercase, header);
    }

    static {
        HttpHeaders.appendHeader(AUTHORIZATION);
        HttpHeaders.appendHeader(CACHE_CONTROL);
        HttpHeaders.appendHeader(CONTENT_DISPOSITION);
        HttpHeaders.appendHeader(CONTENT_ENCODING);
        HttpHeaders.appendHeader(CONTENT_LENGTH);
        HttpHeaders.appendHeader(CONTENT_MD5);
        HttpHeaders.appendHeader(CONTENT_TYPE);
        HttpHeaders.appendHeader(LAST_MODIFIED);
        HttpHeaders.appendHeader(EXPIRES);
    }
}

