/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.cloud.jiuli.client.domian.params;

import cn.com.duiba.cloud.jiuli.client.domian.constants.HttpHeaders;
import cn.com.duiba.cloud.jiuli.client.utils.DateUtil;
import com.google.common.collect.Maps;
import java.io.Serializable;
import java.text.ParseException;
import java.util.Collections;
import java.util.Date;
import java.util.Map;

public class MetadataInfo
implements Serializable {
    private final Map<String, String> metadata = Maps.newHashMap();

    public void setHeader(String key, String value) {
        this.metadata.put(HttpHeaders.formatHeader(key), value);
    }

    public void removeHeader(String key) {
        this.metadata.remove(HttpHeaders.formatHeader(key));
    }

    public Date getLastModified() {
        if (!this.metadata.containsKey("Last-Modified")) {
            return null;
        }
        try {
            return DateUtil.parseRfc822Date(this.metadata.get("Last-Modified"));
        }
        catch (ParseException e) {
            return null;
        }
    }

    public void setLastModified(Date lastModified) {
        this.metadata.put("Last-Modified", DateUtil.formatRfc822Date(lastModified));
    }

    public Date getExpirationTime() throws ParseException {
        String expires = this.metadata.get("Expires");
        if (expires != null) {
            return DateUtil.parseRfc822Date(this.metadata.get("Expires"));
        }
        return null;
    }

    public String getRawExpiresValue() {
        return this.metadata.get("Expires");
    }

    public void setExpirationTime(Date expirationTime) {
        this.metadata.put("Expires", DateUtil.formatRfc822Date(expirationTime));
    }

    public Long getContentLength() {
        String contentLength = this.metadata.get("Content-Length");
        return contentLength == null ? 0L : Long.parseLong(contentLength);
    }

    public void setContentLength(Long contentLength) {
        this.metadata.put("Content-Length", contentLength.toString());
    }

    public String getContentType() {
        return this.metadata.get("Content-Type");
    }

    public void setContentType(String contentType) {
        this.metadata.put("Content-Type", contentType);
    }

    public String getContentMd5() {
        return this.metadata.get("Content-MD5");
    }

    public void setContentMd5(String md5) {
        this.metadata.put("Content-MD5", md5);
    }

    public String getContentEncoding() {
        return this.metadata.get("Content-Encoding");
    }

    public void setContentEncoding(String encoding) {
        this.metadata.put("Content-Encoding", encoding);
    }

    public String getCacheControl() {
        return this.metadata.get("Cache-Control");
    }

    public void setCacheControl(String cacheControl) {
        this.metadata.put("Cache-Control", cacheControl);
    }

    public String getContentDisposition() {
        return this.metadata.get("Content-Disposition");
    }

    public void setContentDisposition(String disposition) {
        this.metadata.put("Content-Disposition", disposition);
    }

    public Map<String, String> getRawMetadata() {
        return Collections.unmodifiableMap(this.metadata);
    }
}

