/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.cloud.jiuli.client.service;

import cn.com.duiba.cloud.jiuli.client.JiuliFileClient;
import cn.com.duiba.cloud.jiuli.client.configuration.FileClientProperties;
import cn.com.duiba.cloud.jiuli.client.configuration.FileSpaceProperties;
import cn.com.duiba.cloud.jiuli.client.service.JiuliFileClientFactory;
import cn.com.duiba.cloud.jiuli.client.service.JiuliFileClientImpl;
import com.github.benmanes.caffeine.cache.CacheLoader;
import com.github.benmanes.caffeine.cache.Caffeine;
import com.github.benmanes.caffeine.cache.LoadingCache;
import java.util.Objects;
import javax.annotation.Resource;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.springframework.context.ApplicationContext;

public class DefaultJiuliFileClientFactory
implements JiuliFileClientFactory {
    @Resource
    private FileClientProperties fileClientProperties;
    @Resource
    private ApplicationContext applicationContext;
    private final LoadingCache<String, String> secretSource = Caffeine.newBuilder().build((CacheLoader)new CacheLoader<String, String>(){

        public @Nullable String load(@NonNull String spaceKey) {
            FileSpaceProperties properties = DefaultJiuliFileClientFactory.this.fileClientProperties.getSpaces().get(spaceKey);
            if (Objects.isNull(properties)) {
                throw new RuntimeException("\u6ca1\u6709\u6587\u4ef6\u7a7a\u95f4[" + spaceKey + "]\u914d\u7f6e");
            }
            return properties.getSecret();
        }
    });

    @Override
    public JiuliFileClient build(String spaceKey) {
        FileSpaceProperties properties = this.fileClientProperties.getSpaces().get(spaceKey);
        if (Objects.isNull(properties)) {
            throw new RuntimeException("\u6ca1\u6709\u6587\u4ef6\u7a7a\u95f4\u7684\u5ba2\u6237\u7aef\u914d\u7f6e");
        }
        JiuliFileClientImpl fileClient = (JiuliFileClientImpl)this.applicationContext.getBean(JiuliFileClientImpl.class);
        fileClient.setSpaceKey(spaceKey);
        return fileClient;
    }

    @Override
    public LoadingCache<String, String> secretSource() {
        return this.secretSource;
    }
}

