/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.cloud.jiuli.client.service;

import cn.com.duiba.boot.exception.BizException;
import cn.com.duiba.cloud.jiuli.client.JiuliFileClient;
import cn.com.duiba.cloud.jiuli.client.domian.dto.FileDto;
import cn.com.duiba.cloud.jiuli.client.domian.params.AppendParams;
import cn.com.duiba.cloud.jiuli.client.domian.params.CreateDirParams;
import cn.com.duiba.cloud.jiuli.client.domian.params.ListFileParams;
import cn.com.duiba.cloud.jiuli.client.domian.params.MetadataInfo;
import cn.com.duiba.cloud.jiuli.client.domian.params.PutFileParams;
import cn.com.duiba.cloud.jiuli.client.domian.result.AppendResult;
import cn.com.duiba.cloud.jiuli.client.domian.result.DeleteResult;
import cn.com.duiba.cloud.jiuli.client.domian.result.FetchResult;
import cn.com.duiba.cloud.jiuli.client.domian.result.PutFileResult;
import cn.com.duiba.cloud.jiuli.client.remote.RemoteJiuliFileApi;
import cn.com.duiba.cloud.jiuli.client.utils.MultipartFileUtils;
import com.google.common.base.Joiner;
import feign.Response;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.List;
import java.util.Map;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.web.multipart.MultipartFile;

public class JiuliFileClientImpl
implements JiuliFileClient {
    private static final Logger log = LoggerFactory.getLogger(JiuliFileClientImpl.class);
    private static final Joiner HEADER_JOINER = Joiner.on((String)",").skipNulls();
    private String spaceKey;
    @Resource
    private RemoteJiuliFileApi remoteJiuliFileClient;

    @Override
    public String getSpaceKey() {
        return this.spaceKey;
    }

    @Override
    public List<FileDto> findChildFiles(ListFileParams params) throws BizException {
        return this.remoteJiuliFileClient.listFile(this.spaceKey, params);
    }

    @Override
    public FetchResult fetchFile(String fileId) throws BizException {
        Response response = this.remoteJiuliFileClient.fetchFile(this.spaceKey, fileId);
        Map headers = response.headers();
        FetchResult result = new FetchResult();
        try {
            MetadataInfo metadataInfo = new MetadataInfo();
            for (String key : headers.keySet()) {
                metadataInfo.setHeader(key, HEADER_JOINER.join((Iterable)headers.get(key)));
            }
            result.setMetadataInfo(metadataInfo);
            result.setInputStream(response.body().asInputStream());
        }
        catch (IOException e) {
            throw new BizException("\u83b7\u53d6\u6587\u4ef6\u6d41\u5931\u8d25:" + e.getMessage());
        }
        return result;
    }

    @Override
    public void createFolder(String filePath) throws BizException {
        CreateDirParams param = new CreateDirParams(filePath);
        this.remoteJiuliFileClient.createFolder(this.spaceKey, param);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public PutFileResult putFile(PutFileParams params, File file) throws BizException {
        MultipartFile multipartFile = MultipartFileUtils.fileToMultipartFile(file);
        try {
            PutFileResult putFileResult = this.remoteJiuliFileClient.putFile(this.spaceKey, params, multipartFile);
            return putFileResult;
        }
        finally {
            MultipartFileUtils.cleanLocalFile(multipartFile);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public PutFileResult putFile(PutFileParams params, InputStream inputStream) throws BizException {
        MultipartFile multipartFile = MultipartFileUtils.fileToMultipartFile(inputStream);
        try {
            PutFileResult putFileResult = this.remoteJiuliFileClient.putFile(this.spaceKey, params, multipartFile);
            return putFileResult;
        }
        finally {
            MultipartFileUtils.cleanLocalFile(multipartFile);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public PutFileResult putFile(PutFileParams params, MultipartFile multipartFile) throws BizException {
        try {
            PutFileResult putFileResult = this.remoteJiuliFileClient.putFile(this.spaceKey, params, multipartFile);
            return putFileResult;
        }
        finally {
            MultipartFileUtils.cleanLocalFile(multipartFile);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public AppendResult appendToFile(AppendParams params, InputStream inputStream) throws BizException {
        MultipartFile multipartFile = MultipartFileUtils.fileToMultipartFile(inputStream);
        try {
            AppendResult appendResult = this.remoteJiuliFileClient.appendFile(this.spaceKey, params, multipartFile);
            return appendResult;
        }
        finally {
            MultipartFileUtils.cleanLocalFile(multipartFile);
        }
    }

    @Override
    public Boolean fileExist(String fileId) throws BizException {
        return this.remoteJiuliFileClient.fileExist(this.spaceKey, fileId).getExist();
    }

    @Override
    public DeleteResult deleteFile(String fileId) throws BizException {
        return this.remoteJiuliFileClient.deleteFile(this.spaceKey, fileId);
    }

    public void setSpaceKey(String spaceKey) {
        this.spaceKey = spaceKey;
    }
}

