/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.cloud.jiuli.client.service.auth;

import cn.com.duiba.cloud.jiuli.client.domian.dto.AuthDto;
import cn.com.duiba.cloud.jiuli.client.domian.params.AuthParams;
import cn.com.duiba.cloud.jiuli.client.remote.RemoteJiuliAuthApi;
import cn.com.duiba.cloud.jiuli.client.service.JiuliFileClientFactory;
import cn.com.duiba.cloud.jiuli.client.service.auth.SignatureUtils;
import com.github.benmanes.caffeine.cache.CacheLoader;
import com.github.benmanes.caffeine.cache.Caffeine;
import com.github.benmanes.caffeine.cache.LoadingCache;
import feign.RequestInterceptor;
import feign.RequestTemplate;
import java.util.Collection;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.TimeUnit;
import javax.annotation.Resource;
import org.apache.commons.lang3.StringUtils;
import org.aspectj.lang.annotation.Aspect;
import org.jetbrains.annotations.NotNull;
import org.springframework.beans.factory.annotation.Value;

@Aspect
public class JiuliClientAuthRequestInterceptor
implements RequestInterceptor {
    @Resource
    private RemoteJiuliAuthApi remoteJiuliAuthApi;
    @Value(value="${spring.application.name}")
    private String appId;
    @Resource
    private JiuliFileClientFactory jiuliFileClientFactory;
    private final LoadingCache<String, AuthDto> stateCache = Caffeine.newBuilder().expireAfterWrite(115L, TimeUnit.MINUTES).build((CacheLoader)new CacheLoader<String, AuthDto>(){

        public AuthDto load(@NotNull String spaceKey) throws Exception {
            String secret = (String)JiuliClientAuthRequestInterceptor.this.jiuliFileClientFactory.secretSource().get((Object)spaceKey);
            if (Objects.isNull(secret)) {
                throw new RuntimeException("\u672a\u8bbe\u7f6e\u6587\u4ef6\u7a7a\u95f4[" + spaceKey + "]\u7684\u79d8\u94a5\uff0c\u65e0\u6cd5\u5bf9\u8be5\u7a7a\u95f4\u8fdb\u884c\u64cd\u4f5c");
            }
            long timestamp = System.currentTimeMillis();
            String signature = SignatureUtils.sign(spaceKey, secret, JiuliClientAuthRequestInterceptor.this.appId, timestamp);
            AuthParams params = new AuthParams();
            params.setAppId(JiuliClientAuthRequestInterceptor.this.appId);
            params.setSpaceKey(spaceKey);
            params.setTimestamp(timestamp);
            params.setSignature(signature);
            return JiuliClientAuthRequestInterceptor.this.remoteJiuliAuthApi.getState(params);
        }
    });

    public void apply(RequestTemplate template) {
        String spaceKey = this.getSpaceKey(template);
        if (StringUtils.isBlank((CharSequence)spaceKey)) {
            return;
        }
        AuthDto authDto = (AuthDto)this.stateCache.get((Object)spaceKey);
        Objects.requireNonNull(authDto);
        template.header("Authorization", new String[]{authDto.getState()});
    }

    private String getSpaceKey(RequestTemplate template) {
        Map queries = template.queries();
        if (queries.containsKey("spaceKey")) {
            return ((Collection)queries.get("spaceKey")).toArray(new String[0])[0];
        }
        return null;
    }
}

