package cn.com.duiba.kjj.center.api.dto.advice;

import lombok.Data;

import java.io.Serializable;

/**
 * 建议话术配置表
 * @author kjj mybatis generator 
 * @date 2021-12-27
 */
@Data
public class AdviceWordDto implements Serializable {
     
    private static final long serialVersionUID = 1640570294315965L;

    /**
     * 主键ID
     */
    private Long id;

    /**
     * 话术类型：1:faq关联问答 2:咨询问题 3:领取资料 4:领取赠险
     */
    private Integer adviceType;

    /**
     * 关联外建ID
     */
    private String bizId;

    /**
     * 话术状态 0:删除 1:可用
     */
    private Integer adviceStatus;

    /**
     * 话术人员；1:代理人 2；访客
     */
    private Integer userType;

    /**
     * 是否可复制 0:不可复制 1:可复制
     */
    private Integer copyStatus;

    /**
     * 建议话术
     */
    private String adviceContent;

    /**
     * 话术关联文章Id
     */
    private Long contentId;
}