package cn.com.duiba.kjj.center.api.dto.clue;

import java.io.Serializable;
import java.util.Date;
import lombok.Data;

/**
 * 销售员的客户表
 * @author kjj mybatis generator 
 * @date 2021-11-23
 */
@Data
public class SellerCustomerDto implements Serializable {
     
    private static final long serialVersionUID = 16376581109661627L;

    /**
     * 主键
     */
    private Long id;

    /**
     * 是否删除，1=已删除，0=未删除
     */
    private Integer deleted;

    /**
     * 用户ID，对应tb_users.id
     */
    private Long userId;

    /**
     * 销售员ID，对应tb_seller.id
     */
    private Long sellerId;

    /**
     * 备注名称
     */
    private String remarkName;

    /**
     * 备注名称拼音
     */
    private String remarkNamePinyin;

    /**
     * 备注名称拼音,首字母
     */
    private String remarkNamePinyinFast;

    /**
     * 顾客意向，企业产品ID，多个英文逗号隔开
     */
    private String custTag;

    /**
     * 顾客：省
     */
    private String custProvince;

    /**
     * 顾客：市
     */
    private String custCity;

    /**
     * 顾客:区
     */
    private String custArea;

    /**
     * 顾客：备注
     */
    private String custRemark;

    /**
     * 最后访问时间
     */
    private Date lastVisitTime;

    /**
     * 访客标志, 1=客户、2=访客
     */
    private Integer custMark;

    /**
     * 访问次数
     */
    private Long visitCount;

    /**
     * 是否与代理人有一级接触
     */
    private Integer isTouched;

    /**
     * 生日(包含是否是阳历，阳历生日)
     */
    private String custBirth;

    /**
     * 客户意向度星级 0-5
     */
    private Integer star;

    /**
     * 客户意向度得分
     */
    private Long score;

    /**
     * 客户来源,1:微信好友,2:二度人脉
     */
    private Integer custOrigin;

    /**
     * 客户行为: 参与答题,参与投票,填写资料,中奖,转发 
     */
    private Integer custAction;

    /**
     * 是否为特别关注客户 0=不是 1=是
     */
    private Integer isSpecialCustomer;

    /**
     * 跟进状态 0待跟进，1已跟进
     */
    private Integer followStatus;

    /**
     * 是否提醒，0=不提醒，1=提醒
     */
    private Integer birthRemind;

    /**
     * 生日，包含农历阳历
     */
    private String birthday;

    /**
     * 生日类型，1农历，2阳历，0无生日
     */
    private Integer birthdayType;

    /**
     * 是否为新用户 0=不是 1=是
     */
    private Integer isNew;

    /**
     * 是否提醒，0=不提醒，1=提醒
     */
    private Integer holidayRemind;

    /**
     * 顾客电话
     */
    private String custPhoneNum;

    /**
     * 是否备注,1已备注,0未备注
     */
    private Integer remarkState;
}