package cn.com.duiba.kjj.center.api.dto.clue;

import java.io.Serializable;
import java.util.Date;
import lombok.Data;

/**
 * 销售动态记录表
 * @author kjj mybatis generator 
 * @date 2021-11-29
 */
@Data
public class SellerDynamicDto implements Serializable {
     
    private static final long serialVersionUID = 16381688907378590L;

    /**
     * 主键
     */
    private Long id;

    /**
     * 销售员ID，对应tb_seller.id
     */
    private Long sellerId;

    /**
     * 业务ID，对应转发记录表、访问记录表和代理人精准素材详情关联表ID
     */
    private Long bizId;

    /**
     * 业务类型：1、转发记录，2、访问记录3销售线索
     */
    private Integer bizType;

    /**
     * 动态类型：1、访客2、转发素材3、转发名片4、使用营销工具5、获得销售线索
     */
    private Integer dynamicType;

    /**
     * 本次转发访问记录
     */
    private Integer visitCount;

    /**
     * 销售内容id,对应tb_seller_content主键id
     */
    private Long scId;
}