package cn.com.duiba.kjj.center.api.dto.invitationLetter;

import java.io.Serializable;
import java.util.Date;
import lombok.Data;

/**
 * 用户访问邀请函记录表
 * @author kjj mybatis generator 
 * @date 2022-01-17
 */
@Data
public class VisitorInvitationLetterRecordDto implements Serializable {
     
    private static final long serialVersionUID = 16424058133328097L;

    /**
     * 主键
     */
    private Long id;

    /**
     * 邀请函ID，对应tb_content.id
     */
    private Long contentId;

    /**
     * 销售员id，对应tb_seller.id
     */
    private Long sellerId;

    /**
     * 用户ID(销售员)，对应 tb_users.id
     */
    private Long sellerUserId;

    /**
     * 邀请函配置ID，对应tb_seller_invitation_letter_conf.id
     */
    private Long confId;

    /**
     * 用户ID(访问者)，对应 tb_users.id
     */
    private Long visitorId;

    /**
     * 受邀人姓名
     */
    private String visitorName;

    /**
     * 阅读标志：0=未读、1=已读
     */
    private Integer readMark;

    /**
     * 访客行为 1:扫码 2:接收邀请
     */
    private Integer actionType;

    /**
     * 受邀人联系电话
     */
    private String visitorPhoneNum;
}