package cn.com.duiba.kjj.center.api.dto.push;

import lombok.Data;

import java.io.Serializable;

/**
 * 销售员推送开关表
 * @author kjj mybatis generator 
 * @date 2021-12-17
 */
@Data
public class SellerPushSwitchDto implements Serializable {
     
    private static final long serialVersionUID = 16397269421849109L;

    /**
     * 主键
     */
    private Long id;

    /**
     * 销售员id，对应tb_seller.id
     */
    private Long sellerId;

    /**
     * 推送类型，1=早报、2=午后话题、3=晚安心语、4=热文、5=来访、6=每日统计、7=每周统计、8=收益统计
     */
    private Integer pushType;

    /**
     * 推送开关，0=关闭、1=开启
     */
    private Integer pushSwitch;

    /**
     * 关闭推送开始时间
     */
    private String closeStartTime;

    /**
     * 关闭推送结束时间
     */
    private String closeEndTime;
}