package cn.com.duiba.kjj.center.api.dto.seller;

import java.io.Serializable;
import java.util.Date;
import lombok.Data;

/**
 * 销售员账户流水表
 * @author kjj mybatis generator 
 * @date 2021-11-16
 */
@Data
public class SellerAccountDetailDto implements Serializable {
     
    private static final long serialVersionUID = 16370545063328006L;

    /**
     * 主键
     */
    private Long id;

    /**
     * 流水号
     */
    private Long detailNo;

    /**
     * 销售员id
     */
    private Long sellerId;

    /**
     * 变更金额(分)
     */
    private Integer changeMoney;

    /**
     * 变更前余额(分)
     */
    private Integer beforeAmount;

    /**
     * 变更类型，1:支出；2:收入
     * @see cn.com.duiba.kjj.center.api.enums.seller.SellerAccountChangeTypeEnum
     */
    private Integer changeType;

    /**
     * 业务类型，1:余额提现；2:邀请奖励；3:二级奖励;
     * @see cn.com.duiba.kjj.center.api.enums.seller.SellerAccountBizTypeEnum
     */
    private Integer bizType;

    /**
     * 业务ID
     */
    private String bizId;

    /**
     * 状态，1:处理中；2:成功;3:失败
     * @see cn.com.duiba.kjj.center.api.enums.seller.SellerAccountDetailStateEnum
     */
    private Integer state;

    /**
     * 好友/下级id
     */
    private Long subordinateId;

    /**
     * 创建时间
     */
    private Date gmtCreate;

    /**
     * 修改时间
     */
    private Date gmtModified;

    /**
     * 备注
     */
    private String remark;

    /**
     * 下级是否申请退款 0:没有 1:申请了
     * @see cn.com.duiba.kjj.center.api.enums.seller.SellerAccountSubordinateCancelEnum
     */
    private Integer subordinateCancel;
}