package cn.com.duiba.kjj.center.api.dto.seller;

import lombok.Data;

import java.io.Serializable;
import java.util.Date;

/**
 * 销售员
 * @author kjj mybatis generator
 * @date 2021-11-09
 */
@Data
public class SellerDto implements Serializable {

    private static final long serialVersionUID = 16364432254369503L;

    /**
     * 主键
     */
    private Long id;

    /**
     * 用户ID，对应tb_users.id
     */
    private Long userId;

    /**
     * 销售员昵称
     */
    private String sellerName;

    /**
     * 头像
     */
    private String avatar;

    /**
     * vip级别，0=不是、1=是
     * @see cn.com.duiba.kjj.center.api.enums.vip.SellerVipEnum
     */
    private Integer vip;

    /**
     * vip开始时间
     */
    private Date vipBeginTime;

    /**
     * vip结束时间
     */
    private Date vipEndTime;

    /**
     * 是否已付费
     * @see cn.com.duiba.kjj.center.api.enums.vip.SellerIsPaidEnum
     */
    private Integer isPaid;

    /**
     * 渠道ID。标记代理人激活的渠道
     */
    private Long channelId;
}
