package cn.com.duiba.kjj.center.api.dto.seller;

import java.io.Serializable;
import java.util.Date;
import lombok.Data;

/**
 * 销售员邀请关系表
 * @author kjj mybatis generator 
 * @date 2021-11-09
 */
@Data
public class SellerInvitationDto implements Serializable {
     
    private static final long serialVersionUID = 16364396297197808L;

    /**
     * 主键
     */
    private Long id;

    /**
     * 销售员id
     */
    private Long sellerId;

    /**
     * 上级ID(seller_id)
     */
    private Long superiorId;

    /**
     * 绑定时间
     */
    private Date bindingTime;

    /**
     * 邀请有效截止日期，为null时代表永久有效
     */
    private Date protectExpireDate;

    /**
     * 客集集来源
     */
    private Integer accessSource;

    /**
     * 返现状态 0可返现(未返现) 1不可返现(已返现)
     * @see cn.com.duiba.kjj.center.api.enums.vip.order.SellerInvitationPromotionEnum
     */
    private Integer hasPromotion;

    /**
     * 顶级邀请人ID(seller_id)
     */
    private Long topSuperiorId;

    /**
     * 邀请链路(seller_id)，级别从高到低，以英文逗号分隔
     */
    private String superiorIds;
}