package cn.com.duiba.kjj.center.api.dto.user;

import java.io.Serializable;
import java.util.Date;
import lombok.Data;

/**
 * 用户版本关联表
 * @author kjj mybatis generator
 * @date 2021-11-12
 */
@Data
public class UserVersionDto implements Serializable {

    private static final long serialVersionUID = 16367014290758868L;

    /**
     * 主键
     */
    private Long id;

    /**
     * 对应tb_users的id字段
     */
    private Long userId;

    /**
     * 对应tb_seller的id字段
     */
    private Long sellerId;

    /**
     * 启用标识 0:未启用 1:启用
     * @see cn.com.duiba.kjy.base.api.enums.BooleanEnum
     */
    private Integer openType;

    /**
     * 用户版本 1:通用版 2:保险专业版
     * @see cn.com.duiba.kjj.center.api.enums.user.UserVersionEnum
     */
    private Integer userVersion;

    /**
     * vip开始时间
     */
    private Date vipBeginTime;

    /**
     * vip结束时间
     */
    private Date vipEndTime;
}