package cn.com.duiba.kjj.center.api.dto.vip;

import java.io.Serializable;
import java.util.Date;
import lombok.Data;

/**
 * vip时长变更记录表
 * @author kjj mybatis generator 
 * @date 2021-11-12
 */
@Data
public class VipChangeRecordDto implements Serializable {
     
    private static final long serialVersionUID = 16367016790902060L;

    /**
     * 主键
     */
    private Long id;

    /**
     * 用户ID
     */
    private Long sellerId;

    /**
     * 变更之前的截止时间
     */
    private Date originalEndTime;

    /**
     * 变更之后的截止时间
     */
    private Date changeEndTime;

    /**
     * 变更时长（天）
     */
    private Integer changeCount;

    /**
     * 变更原因:具体枚举
     * @see cn.com.duiba.kjj.center.api.enums.vip.VipChangeReasonEnum
     */
    private Integer changeReason;

    /**
     * 用户版本
     * @see cn.com.duiba.kjj.center.api.enums.user.UserVersionEnum
     */
    private Integer userVersion;

    /**
     * 订单ID，tb_seller_pay_record.id
     */
    private Long payRecordId;

    /**
     * 变更开始时间
     */
    private Date changeStartTime;
}