package cn.com.duiba.kjj.center.api.dto.vip.order;

import java.io.Serializable;
import java.util.Date;
import lombok.Data;

/**
 * 付款退款记录表
 * @author kjj mybatis generator 
 * @date 2021-11-24
 */
@Data
public class OrderRefundDto implements Serializable {
     
    private static final long serialVersionUID = 16377204249644076L;

    /**
     * 主键ID
     */
    private Long id;

    /**
     * 付款订单ID，tb_seller_pay_record.id
     */
    private Long payOrderId;

    /**
     * 微信的支付ID，tb_seller_pay_record.duiba_trade_no
     */
    private String payWxId;

    /**
     * 微信退款返回的订单ID，tb_seller_pay_record.pay_trade_no
     */
    private String outOrderId;

    /**
     * 支付结果时间
     */
    private Date payResultTime;

    /**
     * 退款业务订单号
     */
    private String bizRefundNo;

    /**
     * 退款金额
     */
    private Integer refundAmount;

    /**
     * 实际退款时间
     */
    private Date refundTime;

    /**
     * 退款申请来源：1:后台操作发起 2:完成60天打卡任务，系统发起
     * @see cn.com.duiba.kjj.center.api.enums.vip.order.OrderRefundSourceEnum
     */
    private Integer refundSource;

    /**
     * 审核状态 ：0:待退款 1:退款中 2:退款成功 3:退款失败
     * @see cn.com.duiba.kjj.center.api.enums.vip.order.OrderRefundStatusEnum
     */
    private Integer refundStatus;

    /**
     * 销售ID
     */
    private Long sellerId;

    /**
     * 审核状态：0:待审核 1:审核通过 2:审核拒绝
     * @see cn.com.duiba.kjj.center.api.enums.process.ProcessCheckStatusEnum
     */
    private Integer checkStatus;

    /**
     * 提交人ID（sso的adminId）
     */
    private Long submitterId;

    /**
     * 提交人姓名（sso的adminName）
     */
    private String submitter;

    /**
     * 提交审批备注
     */
    private String submitRemark;

    /**
     * 创建时间
     */
    private Date gmtCreate;

    /**
     * 更新时间
     */
    private Date gmtModified;
}