package cn.com.duiba.kjj.center.api.dto.vip.promotion;

import java.io.Serializable;
import java.util.Date;
import lombok.Data;

/**
 * 邀请码批次表
 * @author kjj mybatis generator 
 * @date 2021-11-09
 */
@Data
public class PromotionCodeBatchDto implements Serializable {
     
    private static final long serialVersionUID = 16364408930603067L;

    /**
     * 主键
     */
    private Long id;

    /**
     * 有效期截止时间
     */
    private Date deadline;

    /**
     * 数量
     */
    private Integer codeTotal;

    /**
     * 位数
     */
    private Integer digitTotal;

    /**
     * 已使用的数量
     */
    private Integer usedNum;

    /**
     * 公司ID
     */
    private Long companyId;

    /**
     * 备注
     */
    private String remark;

    /**
     * 创建时间
     */
    private Date gmtCreate;

    /**
     * 修改时间
     */
    private Date gmtModified;

    /**
     * 批次邀请码组成规则
     */
    private String batchCodeRule;

    /**
     * 二维码地址
     */
    private String qrCode;

    /**
     * 开始时间
     */
    private Date startTime;

    /**
     * 价格
     */
    private Integer price;

    /**
     * 用户版本 1:通用版 2:保险专业版
     * @see cn.com.duiba.kjj.center.api.enums.user.UserVersionEnum
     */
    private Integer userVersion;

    /**
     * 会员有效时长(月)
     */
    private Integer validityDuration;

    /**
     * 优惠码类型0-未知类型 1-158元/年  2-186元/年  3-286/年 4-386/一年 5-365/年(180天打卡)
     * @see cn.com.duiba.kjj.center.api.enums.vip.promotion.PromotionTypeEnum
     */
    private Integer promotionType;
}