package cn.com.duiba.kjj.center.api.enums.process;

import lombok.AllArgsConstructor;
import lombok.Getter;
import lombok.extern.slf4j.Slf4j;

import java.util.Arrays;
import java.util.Collections;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;

/**
 * 审批状态
 * @author lizhi
 * @date 2021/11/24 11:46 上午
 */
@Slf4j
@Getter
@AllArgsConstructor
public enum ProcessCheckStatusEnum {
    WAIT(0,"等待审核"),
    PASS(1,"审核通过"),
    FAIL(2,"审核拒绝"),
    CANCEL(3, "撤销"),
    ;

    private final Integer code;
    private final String desc;

    private static final Map<Integer, ProcessCheckStatusEnum> ENUM_MAP = Collections.unmodifiableMap(
            Arrays.stream(values()).collect(Collectors.toMap(ProcessCheckStatusEnum::getCode, Function.identity(), (v1, v2) -> {
                log.error("ProcessCheckStatusEnum, type distinct, type={}", v2.getCode());
                return v2;
            }))
    );

    /**
     * 根据状态获取枚举
     * @param code 状态
     * @return 枚举
     */
    public static ProcessCheckStatusEnum getByCode(Integer code) {
        if (code == null) {
            return null;
        }
        return ENUM_MAP.get(code);
    }
}
