package cn.com.duiba.kjj.center.api.enums.vip.order;

import lombok.AllArgsConstructor;
import lombok.Getter;
import lombok.extern.slf4j.Slf4j;

/**
 * 付费支付来源枚举，由BI定义
 * @author lizhi
 * @date 2021/11/9 10:27 上午
 */
@Slf4j
@Getter
@AllArgsConstructor
public enum VipOrderPaySourceEnum {

    DISCOUNTS_QR(1, "优惠码推送进入付费"),
    OPEN_VIP_MENU(2, "点击菜单中开通会员付费"),
    ARTICLE_MIDDLE_LOCATION(3, "文章中间资源位"),
    WHO_HAS_SEEN_ME(4, "谁看过我转化付费"),
    SELLER_RENEW(5, "会员续费"),
    LIVE_SELLER_RENEW(201, "直播会员续费"),
    ;

    /**
     * 来源
     */
    private final Integer code;

    /**
     * 描述
     */
    private final String desc;
}