package cn.com.duiba.kjj.center.api.param.process;

import lombok.Data;

import java.io.Serializable;

/**
 * 审批参数
 * @author lizhi
 * @date 2021/11/24 6:57 下午
 */
@Data
public class ProcessCheckParam implements Serializable {

    private static final long serialVersionUID = -9112531231155344441L;

    /**
     * 审批流程ID，tb_process_flow.id
     */
    private Long id;

    /**
     * 审批人ID，tb_process_role.id
     */
    private Long checkId;

    /**
     * 审批说明
     */
    private String checkRemark;

    /**
     * 审批状态 0:待审批 1:审批通过 2:审批拒绝
     * @see cn.com.duiba.kjj.center.api.enums.process.ProcessCheckStatusEnum
     */
    private Integer checkStatus;

    /**
     * 附件oss地址
     */
    private String accessory;
}
