package cn.com.duiba.kjj.center.api.param.seller;

import cn.com.duiba.kjj.center.api.param.common.PageQuery;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.ToString;

/**
 * 销售员
 * @author kjj mybatis generator 
 * @date 2021-11-09
 */
@Data
@EqualsAndHashCode(callSuper = true)
@ToString(callSuper = true)
public class SellerSearchParam extends PageQuery {
     
    private static final long serialVersionUID = 16364432254419226L;

    /**
     * 用户ID，对应tb_users.id
     */
    private Long userId;

    /**
     * 公司ID
     */
    private Long companyId;

    /**
     * vip级别，0=不是、1=是
     * @see cn.com.duiba.kjj.center.api.enums.vip.SellerVipEnum
     */
    private Integer vip;

    /**
     * 是否是客集集内部销售：0否，1是
     * @see cn.com.duiba.kjy.base.api.enums.BooleanEnum
     */
    private Integer internalSeller;

    /**
     * 销售员手机号
     */
    private String phoneNum;
}