package cn.com.duiba.kjj.center.api.remoteservice.process;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.kjj.center.api.dto.process.ProcessFlowDto;
import cn.com.duiba.kjj.center.api.param.process.ProcessFlowSearchParam;

import java.util.List;

/**
 * @author zhuenhui
 * @date 2021/11/25 16:49
 * @description 审核流程 - RPC 接口
 */
@AdvancedFeignClient
public interface RemoteProcessFlowApiService {

    /**
     * 根据外键查询审批流程列表
     *
     * @param outId 外键Id
     * @return 审批流程列表
     */
    List<ProcessFlowDto> selectByOutId(Long outId);

    /**
     * 查询审批流程
     *
     * @param param 查询参数（审批状态、审核角色）
     * @return 审批流程列表
     */
    List<ProcessFlowDto> selectList(ProcessFlowSearchParam param);
}
