package cn.com.duiba.kjj.center.api.remoteservice.provider;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.kjj.center.api.dto.provider.ProviderChannelDto;
import cn.com.duiba.kjj.center.api.param.provider.ProviderChannelSearchParam;

import java.util.List;

/**
 * @author dugq
 * @date 2021/12/21 3:47 下午
 */
@AdvancedFeignClient
public interface RemoteProviderChannelService {

    List<ProviderChannelDto> selectList(ProviderChannelSearchParam param);


    Long selectCount(ProviderChannelSearchParam param);

    /**
     * 附带redis缓存
     */
    ProviderChannelDto selectById(Long id);

    /**
     * 返回ID。
     * 0表示新增失败
     */
    Long insert(ProviderChannelDto dto);

    /**
     * 自动清理附带redis缓存
     * 只能更新名称和渠道ID。状态单独接口更改
     */
    int update(ProviderChannelDto dto);

    /**
     * 根据公众号ID/应用ID/第三方ID和对应的类型查询配置
     * 返回的可能是失效的
     */
    ProviderChannelDto selectByBizIdAndType(Long bizId, Integer channelType);

    /**
     * 自动清理附带redis缓存
     */
    int updateState(Long id, Integer channelState);
}
