package cn.com.duiba.kjj.center.api.utils;

import org.apache.commons.lang.StringUtils;

import java.util.Objects;

/**
 *
 * id 加密为纯数字。
 * 场景： base64加密长度不固定，且越大的数字越长。在微信的部分场景下，长度有严格限制，使用此加密方式
 *
 * next ：看原作者的解释：
 *
 * 例子:  会员ID 一共7位
 *      第一位: sellerId的长度
 *      第二位: sellerId的最后一位的平方+ 剩余空位数
 *      第三位: (前一位的计算结果)的平方 + 剩余空位数
 *      以此类推 填满剩余空位为止
 *      例子:
 *          sellerId: 0000001
 *          会员ID:   1603121
 *          拆分后算法:
 *          会员ID:   1               6                           0                   3                           1               2                1
 *                  sellerId位数     1*1+5=6(取个位)         6*6+4=40 取个位0      0*0+3=3(取个位3)           3*3+2(取个位:1)       1*1+1(取个位:2)    1*1+0(取个位:1)
 * @auther wuwenzhe
 * @date 2019-08-01 20:10
 */
public class IdEncodeByNumber {


    /**
     * 序列化销售ID  得到 memberId 会员ID
     * @param id  需要加密的ID
     * @param digit  加密过后的位数
     * @return
     */
    protected static Long encode(Long id,Integer digit){
        if(Objects.isNull(id)){
            throw new RuntimeException("ID为空,无法获取会员ID");
        }
        if(id > Math.pow(10,digit-1)-1){
            throw new RuntimeException("id长度超过总位数-1");
        }
        String scIdStr = String.valueOf(id);
        //第一位是长度
        int length = scIdStr.length();
        //需要补位的长度
        int replaceLength = digit-1-length;
        //补位数值
        String replaceStr =  getReplaceStr(replaceLength,scIdStr);

        return Long.valueOf(length + replaceStr + scIdStr);

    }



    /**
     * 反序列化会员ID 校验失败会返回-1
     * @param sourceMemberId
     * @return
     */
    protected static Long decode(Long sourceMemberId){
        return innerDecode(sourceMemberId+"",String.valueOf(sourceMemberId).length());
    }

    /**
     * 内部转换  用会员ID的第一位去截取指定长度的 sellId
     * @param memberId
     * @return
     */
    private static Long innerDecode(String memberId,int digit){
        int length = Integer.valueOf(memberId.substring(0,1));
        int replaceLength = digit-length;
        Long sourceId = Long.valueOf(memberId.substring(replaceLength, digit));
        if(StringUtils.equals(encode(sourceId,digit).toString(),memberId)){
            return sourceId;
        }
        return null;
    }

    /**
     * 根据会员ID 校验会员ID是否正确
     *
     * @param sourceId 原会员ID
     * @return 返回校验结果
     */
    public static boolean validate(Long sourceId,Integer digit){
        String memberId = sourceId+"";
        if(StringUtils.isEmpty(memberId) || memberId.length()!=10){
            return false;
        }
        if(Objects.isNull(digit)){
            digit = String.valueOf(sourceId).length();
        }
        Long realscId = innerDecode(memberId,digit);
        return sourceId.equals(encode(realscId,digit));

    }
    public static String getReplaceStr(int replaceLength, String sellerIdStr) {
        if(replaceLength==0){
            return "";
        }

        //sellerIdStr的首位 1-9
        int start = Integer.valueOf(sellerIdStr.substring(sellerIdStr.length()-1));
        StringBuilder sb = new StringBuilder();
        for(int i = replaceLength; i >0  ;i--){
            //取sellerId的第一位与需要补空的位数值相加
            int replaceNum = start * start + i;
            //获取个位重新赋给start
            start = replaceNum%10;
            //最终字符串追加
            sb.append(start);
        }
        return sb.toString();

    }

    public static void main(String[] args) {
        System.out.println(encode(7290L,7));
    }


}
