/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.kjj.center.api.utils;

import java.util.Objects;
import org.apache.commons.lang.StringUtils;

public class IdEncodeByNumber {
    protected static Long encode(Long id, Integer digit) {
        if (Objects.isNull(id)) {
            throw new RuntimeException("ID\u4e3a\u7a7a,\u65e0\u6cd5\u83b7\u53d6\u4f1a\u5458ID");
        }
        if ((double)id.longValue() > Math.pow(10.0, digit - 1) - 1.0) {
            throw new RuntimeException("id\u957f\u5ea6\u8d85\u8fc7\u603b\u4f4d\u6570-1");
        }
        String scIdStr = String.valueOf(id);
        int length = scIdStr.length();
        int replaceLength = digit - 1 - length;
        String replaceStr = IdEncodeByNumber.getReplaceStr(replaceLength, scIdStr);
        return Long.valueOf(length + replaceStr + scIdStr);
    }

    protected static Long decode(Long sourceMemberId) {
        return IdEncodeByNumber.innerDecode(sourceMemberId + "", String.valueOf(sourceMemberId).length());
    }

    private static Long innerDecode(String memberId, int digit) {
        int length = Integer.valueOf(memberId.substring(0, 1));
        int replaceLength = digit - length;
        Long sourceId = Long.valueOf(memberId.substring(replaceLength, digit));
        if (StringUtils.equals((String)IdEncodeByNumber.encode(sourceId, digit).toString(), (String)memberId)) {
            return sourceId;
        }
        return null;
    }

    public static boolean validate(Long sourceId, Integer digit) {
        String memberId = sourceId + "";
        if (StringUtils.isEmpty((String)memberId) || memberId.length() != 10) {
            return false;
        }
        if (Objects.isNull(digit)) {
            digit = String.valueOf(sourceId).length();
        }
        Long realscId = IdEncodeByNumber.innerDecode(memberId, digit);
        return sourceId.equals(IdEncodeByNumber.encode(realscId, digit));
    }

    public static String getReplaceStr(int replaceLength, String sellerIdStr) {
        if (replaceLength == 0) {
            return "";
        }
        int start = Integer.valueOf(sellerIdStr.substring(sellerIdStr.length() - 1));
        StringBuilder sb = new StringBuilder();
        for (int i = replaceLength; i > 0; --i) {
            int replaceNum = start * start + i;
            start = replaceNum % 10;
            sb.append(start);
        }
        return sb.toString();
    }

    public static void main(String[] args) {
        System.out.println(IdEncodeByNumber.encode(7290L, 7));
    }
}

