package cn.com.duiba.kjj.center.api.dto.push;

import lombok.Data;

import java.io.Serializable;

/**
 * @author xiongkai
 * @version 1.0
 * @date 2021-11-12 14:15
 * 代理人推送数据
 */
@Data
public class SellerPushDataDto implements Serializable {

    private static final long serialVersionUID = 2756150238306329965L;

    /**
     * 主键
     */
    private Long id;

    /**
     * 用户ID，对应tb_users.id
     */
    private Long userId;

    /**
     * 用户的昵称
     */
    private String nickname;

    /**
     * 用户当前正在使用的版本 1:通用版 2:保险专业版
     */
    private Integer userVersion;

    /**
     * 用户ID，对应tb_seller.id
     */
    private Long sellerId;

    /**
     * 销售员昵称
     */
    private String sellerName;

    /**
     * 推送用户类型 对应 PushUserTypeEnum
     */
    private Integer pushUserType;

    /**
     * 关注公众号的数量
     */
    private Integer subscribeNum;

    /**
     * 用户的标识，对当前公众号唯一
     */
    private String openId;

    /**
     * 正在使用的公众号id 对应tb_official_accounts.id
     */
    private Long usingOaId;
}
