package cn.com.duiba.kjj.center.api.remoteservice.push;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.kjj.center.api.dto.push.MessageConfigDto;

/**
 * @author xiongkai
 * @version 1.0
 * @date 2021-11-12 15:36
 * 消息配置service
 */
@AdvancedFeignClient
public interface RemoteMessageConfigService {

    /**
     * 根据消息类型枚举和oaId获取消息配置
     * @param mark 消息类型枚举
     * @see cn.com.duiba.kjy.api.api.enums.MessageMarkEnum
     * @param oaId 公众号id
     * @return 消息配置
     */
    MessageConfigDto selectByMarkAndOaId(Integer mark, Long oaId);
}
