/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.kjy.base.api.utils;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Supplier;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.math.NumberUtils;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JSONPath {
    private static final Logger log = LoggerFactory.getLogger(JSONPath.class);
    private JSONObject jsonObject;
    private JSONArray jsonArray;
    private Object otherObj;
    private JsonType jsonType;
    private Object obj;
    private static final Supplier DEFAULT_GET = () -> null;
    private static final char LEVEL_SEP = '.';
    private static final char prop_sep = ',';
    private static final char array_start = '[';
    private static final char array_end = ']';
    private static final char obj_start = '{';
    private static final char obj_end = '}';
    private static final List<Character> important_chars = Arrays.asList(Character.valueOf('['), Character.valueOf(']'), Character.valueOf('{'), Character.valueOf('}'), Character.valueOf('.'), Character.valueOf(','));
    private Integer recursionCount = 0;
    private static final Integer MAX_RECURSION_COUNT = 200;

    public JSONPath(String jsonStr) {
        Object parse = JSON.parse((String)jsonStr);
        if (parse instanceof JSONObject) {
            this.jsonObject = (JSONObject)parse;
            this.jsonType = JsonType.OBJ;
        } else if (parse instanceof JSONArray) {
            this.jsonArray = (JSONArray)parse;
            this.jsonType = JsonType.ARRAY;
        } else {
            this.otherObj = parse;
            this.jsonType = JsonType.OTHER;
        }
    }

    public boolean isJSON() {
        return this.jsonType == JsonType.OBJ || this.jsonType == JsonType.ARRAY;
    }

    public String getString(String fullPath, Supplier<String> elseGet) {
        Object result;
        this.recursionCount = 0;
        if (Objects.isNull(elseGet)) {
            elseGet = DEFAULT_GET;
        }
        if (StringUtils.isBlank((String)fullPath)) {
            return (String)elseGet.get();
        }
        try {
            result = this.getObject(fullPath);
        }
        catch (Exception e) {
            result = null;
        }
        return Objects.isNull(result) ? (String)elseGet.get() : result.toString();
    }

    public JSONObject getObject(String fullPath, Supplier<JSONObject> elseGet) {
        Object result;
        this.recursionCount = 0;
        if (Objects.isNull(elseGet)) {
            elseGet = DEFAULT_GET;
        }
        if (StringUtils.isBlank((String)fullPath)) {
            return (JSONObject)elseGet.get();
        }
        try {
            result = this.getObject(fullPath);
        }
        catch (Exception e) {
            result = null;
        }
        return result instanceof JSONObject ? (JSONObject)result : (JSONObject)elseGet.get();
    }

    @Nullable
    private Object getObject(String fullPath) {
        List<Path> paths = this.explainPattern(fullPath);
        switch (this.jsonType) {
            case OBJ: {
                return this.doExplainByLevel(paths, this.jsonObject);
            }
            case ARRAY: {
                return this.doExplainByLevel(paths, this.jsonArray);
            }
        }
        return null;
    }

    @Nullable
    private Object doExplainByLevel(List<Path> sortedPath, Object result) {
        Integer n = this.recursionCount;
        Integer n2 = this.recursionCount = Integer.valueOf(this.recursionCount + 1);
        if (n > MAX_RECURSION_COUNT) {
            throw new RuntimeException("\u8d85\u8fc7\u6700\u5927\u6df1\u5ea6");
        }
        for (int i = 0; i < sortedPath.size(); ++i) {
            Path currentPath = sortedPath.get(i);
            if (Objects.isNull(result)) break;
            if (result instanceof JSONObject) {
                result = this.getObjectFromObject((JSONObject)result, currentPath);
                continue;
            }
            if (result instanceof JSONArray) {
                if (currentPath.type == PathType.ARRAY && StringUtils.isBlank((String)currentPath.value)) {
                    result = this.getArrayFromArray(sortedPath.subList(i + 1, sortedPath.size()), (JSONArray)result);
                    break;
                }
                if (currentPath.type == PathType.ARRAY) {
                    result = this.getObjectFromArray(currentPath.value, (JSONArray)result);
                    continue;
                }
                result = null;
                continue;
            }
            return null;
        }
        return result;
    }

    private Object getObjectFromObject(JSONObject result, Path currentPath) {
        if (currentPath.type == PathType.OBJECT) {
            JSONObject jsonObject = new JSONObject();
            for (List<Path> props : currentPath.subPath) {
                jsonObject.put(props.get((int)(props.size() - 1)).value, this.doExplainByLevel(props, result));
            }
            return jsonObject;
        }
        if (currentPath.type == PathType.String) {
            return result.get((Object)currentPath.value);
        }
        return null;
    }

    private Object getArrayFromArray(List<Path> currentPath, JSONArray result) {
        JSONArray arrayResult = new JSONArray();
        for (Object subResult : result) {
            arrayResult.add(this.doExplainByLevel(currentPath, subResult));
        }
        return arrayResult;
    }

    private Object getObjectFromArray(String currentPath, JSONArray result) {
        if (NumberUtils.isCreatable((String)currentPath)) {
            return result.get(Integer.parseInt(currentPath));
        }
        return null;
    }

    private List<Path> explainPattern(String fullPath) {
        AtomicInteger index = new AtomicInteger();
        try {
            char[] chars = fullPath.toCharArray();
            ArrayList<Path> pathList = new ArrayList<Path>();
            while (index.get() < chars.length) {
                if (chars[index.get()] == '.') {
                    index.incrementAndGet();
                }
                pathList.add(this.builderPath(chars, index));
            }
            return pathList;
        }
        catch (Exception e) {
            log.error("", (Throwable)e);
            throw new RuntimeException("illegal char at " + index.get() + "value = " + fullPath.charAt(index.get()) + " in json string = " + fullPath);
        }
    }

    private Path builderPath(char[] sourceChars, AtomicInteger index) {
        char currentChar = sourceChars[index.get()];
        if (currentChar == '{') {
            Path path = this.buildObjectPath(sourceChars, index);
            return path;
        }
        if (currentChar == '[') {
            Path path = this.buildArrayPath(sourceChars, index);
            return path;
        }
        Path path = this.buildStringPath(sourceChars, index);
        return path;
    }

    private Path buildObjectPath(char[] sourceChars, AtomicInteger index) {
        char currentChar = sourceChars[index.get()];
        ArrayList<List<Path>> subPathList = new ArrayList<List<Path>>();
        ArrayList<Path> subPath = new ArrayList<Path>();
        while (index.incrementAndGet() < sourceChars.length) {
            subPath.add(this.builderPath(sourceChars, index));
            currentChar = sourceChars[index.get()];
            if (currentChar == ',' || currentChar == '}') {
                subPathList.add(subPath);
                subPath = new ArrayList();
            }
            if (currentChar != '}') continue;
            index.incrementAndGet();
            break;
        }
        Path currentPath = new Path(null, PathType.OBJECT);
        currentPath.subPath = subPathList;
        return currentPath;
    }

    private Path buildArrayPath(char[] sourceChars, AtomicInteger index) {
        int start = index.get() + 1;
        char currentChar = sourceChars[index.get()];
        while (index.incrementAndGet() < sourceChars.length && (currentChar = sourceChars[index.get()]) != ']') {
        }
        String arrayIndex = new String(ArrayUtils.subarray((char[])sourceChars, (int)start, (int)index.get()));
        if (currentChar == ']') {
            index.incrementAndGet();
        }
        return new Path(arrayIndex, PathType.ARRAY);
    }

    private Path buildStringPath(char[] sourceChars, AtomicInteger index) {
        int start = index.get();
        while (index.incrementAndGet() < sourceChars.length && !important_chars.contains(Character.valueOf(sourceChars[index.get()]))) {
        }
        String Key2 = new String(ArrayUtils.subarray((char[])sourceChars, (int)start, (int)index.get()));
        return new Path(Key2, PathType.String);
    }

    static enum PathType {
        String,
        ARRAY,
        OBJECT;

    }

    class Path {
        String value;
        PathType type;
        List<List<Path>> subPath;

        public Path(String value, PathType type) {
            this.value = value;
            this.type = type;
        }
    }

    static enum JsonType {
        OBJ,
        ARRAY,
        OTHER;

    }
}

