/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.kjy.base.customweb.autoconfig.graceclose;

import ch.qos.logback.classic.Level;
import ch.qos.logback.classic.LoggerContext;
import cn.com.duiba.boot.event.ContextClosingEvent;
import cn.com.duiba.kjy.base.customweb.sever.CustomNettyServer;
import cn.com.duiba.wolf.threadpool.NamedThreadFactory;
import cn.com.duibaboot.ext.autoconfigure.web.ServerStatusHolder;
import com.alibaba.ttl.threadpool.TtlExecutors;
import com.netflix.discovery.EurekaClient;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.IdentityHashMap;
import java.util.Map;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.NoSuchBeanDefinitionException;
import org.springframework.boot.SpringApplication;
import org.springframework.boot.SpringApplicationRunListener;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationEvent;
import org.springframework.context.ConfigurableApplicationContext;
import org.springframework.context.event.SimpleApplicationEventMulticaster;
import org.springframework.core.env.ConfigurableEnvironment;

public class KjjGracefulCloseRunListener
implements SpringApplicationRunListener {
    private static final Logger logger = LoggerFactory.getLogger(KjjGracefulCloseRunListener.class);
    private SpringApplication application;

    public KjjGracefulCloseRunListener(SpringApplication application, String[] args) {
        this.application = application;
    }

    public void started() {
    }

    public void starting() {
    }

    public void environmentPrepared(ConfigurableEnvironment environment) {
    }

    public void contextPrepared(ConfigurableApplicationContext context) {
    }

    public void contextLoaded(ConfigurableApplicationContext context) {
    }

    public void started(ConfigurableApplicationContext context) {
        try {
            context.getBean(CustomNettyServer.class);
        }
        catch (BeansException e) {
            return;
        }
        this.printHomePageUrl(context);
        try {
            Class<?> clazz = Class.forName("java.lang.ApplicationShutdownHooks");
            Field field = clazz.getDeclaredField("hooks");
            field.setAccessible(true);
            IdentityHashMap hooks = (IdentityHashMap)field.get(null);
            ArrayList keys2remove = new ArrayList();
            if (hooks == null) {
                return;
            }
            for (Map.Entry entry : hooks.entrySet()) {
                String hookClassName = ((Thread)entry.getKey()).getClass().getName();
                if (hookClassName.equals("java.util.logging.LogManager$Cleaner") || hookClassName.equals("org.unidal.helper.Threads$Manager$1") || hookClassName.startsWith("org.jacoco.agent.rt") || hookClassName.startsWith("org.quartz")) continue;
                logger.debug("remove shotdownhook:{}", (Object)hookClassName);
                keys2remove.add(entry.getKey());
            }
            for (Thread t : keys2remove) {
                hooks.remove(t);
            }
            this.addShutDownHook(context);
        }
        catch (IllegalStateException clazz) {
        }
        catch (Exception e) {
            logger.error(e.getMessage(), (Throwable)e);
        }
    }

    private void addShutDownHook(final ConfigurableApplicationContext context) {
        Runtime.getRuntime().addShutdownHook(new Thread("ShutDownThread"){

            @Override
            public void run() {
                long start = System.currentTimeMillis();
                if (!logger.isInfoEnabled()) {
                    LoggerContext loggerContext = (LoggerContext)LoggerFactory.getILoggerFactory();
                    loggerContext.getLogger(KjjGracefulCloseRunListener.class).setLevel(Level.INFO);
                }
                logger.info("begin to shutdown server...");
                context.publishEvent((ApplicationEvent)new ContextClosingEvent((ApplicationContext)context));
                logger.info("disable /monitor/check");
                ServerStatusHolder.setInService((boolean)false);
                try {
                    Class.forName("com.netflix.discovery.EurekaClient");
                    EurekaClient eurekaClient = (EurekaClient)context.getBean(EurekaClient.class);
                    if (eurekaClient != null) {
                        logger.info("unregister from eureka-server");
                        eurekaClient.shutdown();
                    }
                }
                catch (ClassNotFoundException | NoClassDefFoundError | NoSuchBeanDefinitionException e) {
                    logger.warn("unregister from eureka-server failed", e);
                }
                SimpleApplicationEventMulticaster multicaster = (SimpleApplicationEventMulticaster)context.getBean("applicationEventMulticaster", SimpleApplicationEventMulticaster.class);
                if (multicaster != null) {
                    multicaster.setTaskExecutor((Executor)TtlExecutors.getTtlExecutorService((ExecutorService)new ThreadPoolExecutor(1, 5, 10L, TimeUnit.SECONDS, new LinkedBlockingQueue<Runnable>(), (ThreadFactory)new NamedThreadFactory("spring-event-multicaster-"))));
                }
                logger.info("sleep 4 seconds before shutdown");
                try {
                    TimeUnit.SECONDS.sleep(4L);
                }
                catch (InterruptedException e) {
                    Thread.currentThread().interrupt();
                }
                logger.info("clean up spring begin");
                try {
                    context.close();
                }
                catch (Throwable e) {
                    logger.error(e.getMessage(), e);
                }
                long period = System.currentTimeMillis() - start;
                logger.info("shutdown server finished successfully\uff0ccost\uff1a{} ms, bye bye...", (Object)period);
                LoggerContext loggerContext = (LoggerContext)LoggerFactory.getILoggerFactory();
                loggerContext.stop();
            }
        });
    }

    private void printHomePageUrl(ConfigurableApplicationContext context) {
        Class mainApplicationClass = this.application.getMainApplicationClass();
        ch.qos.logback.classic.Logger mainLogger = (ch.qos.logback.classic.Logger)LoggerFactory.getLogger((Class)mainApplicationClass);
        mainLogger.setLevel(Level.INFO);
        String port = context.getEnvironment().getProperty("server.port");
        String contextPath = context.getEnvironment().getProperty("server.context-path");
        if (StringUtils.isBlank((CharSequence)contextPath)) {
            contextPath = context.getEnvironment().getProperty("server.contextPath");
        }
        contextPath = StringUtils.trimToEmpty((String)contextPath);
        String profile = context.getEnvironment().getProperty("spring.profiles.active");
        mainLogger.info("current profile:{}, home page: http://localhost:{}{}", new Object[]{profile, port, contextPath});
    }

    public void running(ConfigurableApplicationContext context) {
    }

    public void failed(ConfigurableApplicationContext context, Throwable exception) {
    }
}

