/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.kjy.base.customweb.web.bean;

import cn.com.duiba.kjy.base.customweb.exception.ResponseClosedException;
import io.netty.buffer.ByteBuf;
import io.netty.channel.ChannelFutureListener;
import io.netty.channel.ChannelHandlerContext;
import io.netty.handler.codec.http.DefaultFullHttpResponse;
import io.netty.handler.codec.http.FullHttpRequest;
import io.netty.handler.codec.http.FullHttpResponse;
import io.netty.handler.codec.http.HttpHeaderNames;
import io.netty.handler.codec.http.HttpHeaderValues;
import io.netty.handler.codec.http.HttpHeaders;
import io.netty.handler.codec.http.HttpResponseStatus;
import io.netty.handler.codec.http.HttpVersion;
import io.netty.handler.codec.http.cookie.Cookie;
import io.netty.util.AsciiString;
import io.netty.util.concurrent.GenericFutureListener;
import java.nio.charset.Charset;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class KjjHttpResponse {
    private static final Logger log = LoggerFactory.getLogger(KjjHttpResponse.class);
    private final ChannelHandlerContext ctx;
    private final FullHttpRequest httpRequest;
    private boolean close;
    private final ByteBuf content;
    private final FullHttpResponse response;

    public KjjHttpResponse(ChannelHandlerContext ctx, FullHttpRequest httpRequest) {
        this.ctx = ctx;
        this.httpRequest = httpRequest;
        this.content = ctx.alloc().buffer();
        this.response = new DefaultFullHttpResponse(HttpVersion.HTTP_1_1, HttpResponseStatus.OK, this.content);
    }

    public boolean isClosed() {
        return this.close;
    }

    public void addCookie(Cookie cookie) {
        this.validator();
        this.addHeader(HttpHeaderNames.SET_COOKIE, cookie);
    }

    public void addHeader(HttpHeaders headers) {
        this.validator();
        this.response.headers().add(headers);
    }

    public void addHeader(AsciiString name, Object value) {
        this.validator();
        this.response.headers().add((CharSequence)name, value);
    }

    public ByteBuf writeBoolean(boolean value) {
        this.validator();
        return this.content.writeBoolean(value);
    }

    public ByteBuf writeByte(int value) {
        this.validator();
        return this.content.writeByte(value);
    }

    public ByteBuf writeShort(int value) {
        this.validator();
        return this.content.writeShort(value);
    }

    public ByteBuf writeInt(int value) {
        this.validator();
        return this.content.writeInt(value);
    }

    public ByteBuf writeLong(long value) {
        this.validator();
        return this.content.writeLong(value);
    }

    public ByteBuf writeChar(int value) {
        this.validator();
        return this.content.writeChar(value);
    }

    public ByteBuf writeFloat(float value) {
        this.validator();
        return this.content.writeFloat(value);
    }

    public ByteBuf writeDouble(double value) {
        this.validator();
        return this.content.writeDouble(value);
    }

    public ByteBuf writeBytes(byte[] src) {
        this.validator();
        return this.content.writeBytes(src);
    }

    public int writeCharSequence(CharSequence sequence, Charset charset) {
        this.validator();
        return this.content.writeCharSequence(sequence, charset);
    }

    public void write(String response) {
        this.validator();
        this.content.writeCharSequence((CharSequence)response, Charset.defaultCharset());
    }

    public void flushAndClose() {
        if (this.close) {
            return;
        }
        this.close = true;
        this.response.headers().set((CharSequence)HttpHeaderNames.CONTENT_LENGTH, (Object)this.response.content().readableBytes());
        if (this.httpRequest.headers().containsValue((CharSequence)HttpHeaderNames.CONNECTION, (CharSequence)HttpHeaderValues.KEEP_ALIVE, true)) {
            this.response.headers().set((CharSequence)HttpHeaderNames.CONNECTION, (Object)HttpHeaderValues.KEEP_ALIVE);
            this.ctx.writeAndFlush((Object)this.response);
        } else {
            this.ctx.writeAndFlush((Object)this.response).addListener((GenericFutureListener)ChannelFutureListener.CLOSE);
        }
    }

    private void validator() {
        if (this.close) {
            throw new ResponseClosedException();
        }
    }

    public void setContentType(String contentType) {
        this.addHeader(HttpHeaderNames.CONTENT_TYPE, contentType);
    }

    public void setStatus(HttpResponseStatus status) {
        this.response.setStatus(status);
    }

    public ChannelHandlerContext getCtx() {
        return this.ctx;
    }

    public FullHttpRequest getHttpRequest() {
        return this.httpRequest;
    }

    public boolean isClose() {
        return this.close;
    }

    public ByteBuf getContent() {
        return this.content;
    }

    public FullHttpResponse getResponse() {
        return this.response;
    }

    public void setClose(boolean close) {
        this.close = close;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof KjjHttpResponse)) {
            return false;
        }
        KjjHttpResponse other = (KjjHttpResponse)o;
        if (!other.canEqual(this)) {
            return false;
        }
        ChannelHandlerContext this$ctx = this.getCtx();
        ChannelHandlerContext other$ctx = other.getCtx();
        if (this$ctx == null ? other$ctx != null : !this$ctx.equals(other$ctx)) {
            return false;
        }
        FullHttpRequest this$httpRequest = this.getHttpRequest();
        FullHttpRequest other$httpRequest = other.getHttpRequest();
        if (this$httpRequest == null ? other$httpRequest != null : !this$httpRequest.equals(other$httpRequest)) {
            return false;
        }
        if (this.isClose() != other.isClose()) {
            return false;
        }
        ByteBuf this$content = this.getContent();
        ByteBuf other$content = other.getContent();
        if (this$content == null ? other$content != null : !this$content.equals(other$content)) {
            return false;
        }
        FullHttpResponse this$response = this.getResponse();
        FullHttpResponse other$response = other.getResponse();
        return !(this$response == null ? other$response != null : !this$response.equals(other$response));
    }

    protected boolean canEqual(Object other) {
        return other instanceof KjjHttpResponse;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        ChannelHandlerContext $ctx = this.getCtx();
        result = result * 59 + ($ctx == null ? 43 : $ctx.hashCode());
        FullHttpRequest $httpRequest = this.getHttpRequest();
        result = result * 59 + ($httpRequest == null ? 43 : $httpRequest.hashCode());
        result = result * 59 + (this.isClose() ? 79 : 97);
        ByteBuf $content = this.getContent();
        result = result * 59 + ($content == null ? 43 : $content.hashCode());
        FullHttpResponse $response = this.getResponse();
        result = result * 59 + ($response == null ? 43 : $response.hashCode());
        return result;
    }

    public String toString() {
        return "KjjHttpResponse(ctx=" + this.getCtx() + ", httpRequest=" + this.getHttpRequest() + ", close=" + this.isClose() + ", content=" + this.getContent() + ", response=" + this.getResponse() + ")";
    }
}

