package cn.com.duiba.kjy.base.api.service.datasource;

import cn.com.duibaboot.ext.autoconfigure.core.SpecifiedBeanPostProcessor;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.BeansException;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.context.ApplicationContext;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.data.redis.core.StringRedisTemplate;

import javax.annotation.Resource;
import javax.sql.DataSource;

/**
 * @author dugq
 * @date 2021/4/21 6:23 下午
 */
@Configuration
@ConditionalOnProperty(prefix = "kjj.datasource.moving",name = "enable",havingValue = "true")
@Slf4j
public class DbMovingAutoConfig {

    @Bean
    public DbMovingSwitchFilter dbMovingSwitchFilter(){
        return new DbMovingSwitchFilter();
    }

    @Bean
    public MovingDataSourceConfiguration dataSourceConfiguration(){
        return new MovingDataSourceConfiguration();
    }

    @Bean
    public static SpecifiedBeanPostProcessor<DataSource> dbMovingSpecifiedBeanPostProcessor(){
        return new SpecifiedBeanPostProcessor<DataSource>(){
            @Resource
            private MovingDataSourceConfiguration movingDataSourceConfiguration;

            @Resource
            private ApplicationContext applicationContext;


            @Override
            public int getOrder() {
                //在perf 之后执行。保证perf的正常使用
                return Integer.MAX_VALUE;
            }

            @Override
            public Class<DataSource> getBeanType() {
                return DataSource.class;
            }

            @Override
            public DataSource postProcessBeforeInitialization(DataSource bean, String beanName) throws BeansException {
                return bean;
            }

            @Override
            public DataSource postProcessAfterInitialization(DataSource bean, String beanName) throws BeansException {
                if (!movingDataSourceConfiguration.getDb().containsKey(beanName)){
                    return bean;
                }
                final MovingDbProperties movingDbProperties = movingDataSourceConfiguration.getDb().get(beanName);
                final String redisKey = movingDbProperties.getRedisKey();
                final String newDataSourceBeanName = movingDbProperties.getNewDataSource();
                final DataSource newDbBean = applicationContext.getBean(newDataSourceBeanName,DataSource.class);
                final DbMovingDataSource dbMovingDataSource = new DbMovingDataSource(bean, newDbBean, redisKey,this::getFlag);
                dbMovingDataSource.afterPropertiesSet();
                return dbMovingDataSource;
            }

            public String getFlag(String redisKey){
                final StringRedisTemplate stringRedisTemplate = applicationContext.getBean("stringRedisTemplate", StringRedisTemplate.class);
                return stringRedisTemplate.opsForValue().get(redisKey);
            }
        };
    }

}
