package cn.com.duiba.kjy.base.reactive.config;

import cn.com.duiba.kjy.base.reactive.convert.HttpReader;
import cn.com.duiba.kjy.base.reactive.convert.IdArgumentResolver;
import org.springframework.http.codec.ServerCodecConfigurer;
import org.springframework.web.reactive.config.WebFluxConfigurer;
import org.springframework.web.reactive.result.method.annotation.ArgumentResolverConfigurer;

import javax.annotation.Resource;

/**
 * @author dugq
 * @date 2021/3/18 7:51 下午
 */
public class ReactiveWebConfig implements WebFluxConfigurer {
    @Resource
    private IdArgumentResolver idArgumentResolver;

    @Resource
    private HttpReader httpReader;

    /**
     * 注册一个自定义的参数解析器，以解析 encode id in Http Get query params
     */
    @Override
    public void configureArgumentResolvers(ArgumentResolverConfigurer configurer) {
        configurer.addCustomResolver(idArgumentResolver);
    }

    /**
     * 自定义转码器，以解析 encode id in Http Post body
     * 额外说明： 转码器是 参数解析器中的一部分内容，用于读取Http request中的数据
     */
    @Override
    public void configureHttpMessageCodecs(ServerCodecConfigurer configurer) {
        configurer.customCodecs().register(httpReader);
    }

}
